/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.orm.inmemory;

import com.mware.core.orm.ModelMetadata;
import com.mware.core.orm.ModelMetadataBuilder;
import com.mware.core.orm.SimpleOrmContext;
import com.mware.core.orm.inmemory.SimpleOrmItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InMemoryOrmTable<T> {
    protected final ModelMetadata<T> modelMetadata;
    private final List<SimpleOrmItem<T>> data = new ArrayList<SimpleOrmItem<T>>();

    public InMemoryOrmTable(Class<T> rowClass) {
        this.modelMetadata = ModelMetadataBuilder.build(rowClass);
    }

    public Class getEntityRowClass() {
        return this.modelMetadata.getEntityRowClass();
    }

    public String getName() {
        return this.modelMetadata.getTableName();
    }

    public Iterable<T> findAll(SimpleOrmContext context) {
        final Iterable<SimpleOrmItem<T>> allItemsIterable = this.findAllItems(context);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator it = allItemsIterable.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T next() {
                        return ((SimpleOrmItem)it.next()).getObj();
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }
        };
    }

    public Iterable<T> findAllInRange(SimpleOrmContext context) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Iterable<SimpleOrmItem<T>> findAllItems(SimpleOrmContext context) {
        return this.data;
    }

    public T findById(String id, SimpleOrmContext context) {
        SimpleOrmItem<T> item = this.findItemById(id, context);
        if (item == null) {
            return null;
        }
        return item.getObj();
    }

    protected SimpleOrmItem<T> findItemById(String id, SimpleOrmContext context) {
        for (SimpleOrmItem<T> item : this.findAllItems(context)) {
            if (!this.modelMetadata.getId(item.getObj()).equals(id)) continue;
            return item;
        }
        return null;
    }

    public Iterable<T> findByIdStartsWith(String idPrefix, SimpleOrmContext context) {
        ArrayList<T> results = new ArrayList<T>();
        for (T t : this.findAll(context)) {
            if (!this.modelMetadata.getId(t).startsWith(idPrefix)) continue;
            results.add(t);
        }
        return results;
    }

    public void save(T obj, String visibility, SimpleOrmContext context) {
        String id = this.modelMetadata.getId(obj);
        this.delete(id, context);
        this.data.add(new SimpleOrmItem<T>(id, obj, visibility));
    }

    public void delete(String id, SimpleOrmContext context) {
        SimpleOrmItem<T> item = this.findItemById(id, context);
        if (item == null) {
            return;
        }
        this.data.remove(item);
    }
}

