/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.orm.inmemory;

import com.mware.core.orm.SimpleOrmContext;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.orm.inmemory.InMemoryOrmTable;
import com.mware.core.orm.inmemory.InMemorySimpleOrmContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class InMemorySimpleOrmSession
extends SimpleOrmSession {
    private Map<Class, InMemoryOrmTable> tables;

    public InMemorySimpleOrmSession() {
        this(new HashMap<Class, InMemoryOrmTable>());
    }

    public InMemorySimpleOrmSession(Map<Class, InMemoryOrmTable> tables) {
        this.tables = tables;
    }

    @Override
    public SimpleOrmContext createContext(String ... authorizations) {
        return new InMemorySimpleOrmContext(authorizations);
    }

    @Override
    public String getTablePrefix() {
        return "";
    }

    @Override
    public Iterable<String> getTableList(SimpleOrmContext simpleOrmContext) {
        ArrayList<String> tableList = new ArrayList<String>();
        for (InMemoryOrmTable table : this.tables.values()) {
            tableList.add(table.getName());
        }
        return tableList;
    }

    @Override
    public void deleteTable(String tableName, SimpleOrmContext simpleOrmContext) {
        for (Map.Entry<Class, InMemoryOrmTable> tableEntry : this.tables.entrySet()) {
            if (!tableEntry.getValue().getName().equals(tableName)) continue;
            this.tables.remove(tableEntry.getKey());
        }
    }

    @Override
    public void clearTable(String table, SimpleOrmContext simpleOrmContext) {
        this.deleteTable(table, simpleOrmContext);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> rowClass, SimpleOrmContext context) {
        InMemoryOrmTable<T> table = this.getTable(rowClass);
        return table.findAll(context);
    }

    @Override
    public <T> Iterable<T> findAllInRange(String startKey, String endKey, Class<T> rowClass, SimpleOrmContext context) {
        InMemoryOrmTable<T> table = this.getTable(rowClass);
        return table.findAllInRange(context);
    }

    @Override
    public <T> T findById(Class<T> rowClass, String id, SimpleOrmContext context) {
        InMemoryOrmTable<T> table = this.getTable(rowClass);
        return table.findById(id, context);
    }

    @Override
    public <T> Iterable<T> findByIdStartsWith(Class<T> rowClass, String idPrefix, SimpleOrmContext context) {
        InMemoryOrmTable<T> table = this.getTable(rowClass);
        return table.findByIdStartsWith(idPrefix, context);
    }

    @Override
    public <T> void save(T obj, String visibility, SimpleOrmContext context) {
        InMemoryOrmTable<?> table = this.getTable(obj.getClass());
        table.save(obj, visibility, context);
    }

    @Override
    public <T> void delete(Class<T> rowClass, String id, SimpleOrmContext context) {
        InMemoryOrmTable<T> table = this.getTable(rowClass);
        table.delete(id, context);
    }

    protected <T> InMemoryOrmTable<T> getTable(Class<T> rowClass) {
        InMemoryOrmTable table = this.tables.get(rowClass);
        if (table == null) {
            for (Class<T> c = rowClass.getSuperclass(); c != null && table == null; c = c.getSuperclass()) {
                table = this.tables.get(c);
            }
        }
        if (table != null) {
            return table;
        }
        table = new InMemoryOrmTable(rowClass);
        this.tables.put(table.getEntityRowClass(), table);
        return table;
    }

    @Override
    public void close() {
    }
}

