/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.orm.sql;

import com.mware.core.orm.ModelMetadata;
import com.mware.core.orm.SimpleOrmException;
import java.util.Collection;

public class SqlGenerator {
    public static final String SQL_DROP_TABLE = "DROP TABLE %s";
    public static final String SQL_CLEAR_TABLE = "DELETE FROM %s";
    public static final String SQL_FIND_ALL = "SELECT * FROM %s";
    public static final String SQL_FIND_BY_ID = "SELECT * FROM %s WHERE id=?";
    public static final String SQL_FIND_BY_ID_STARTS_WITH = "SELECT * FROM %s WHERE id LIKE ?";
    public static final String SQL_DELETE = "DELETE FROM %s WHERE id=?";
    private final String tablePrefix;
    private static final int ID_VARCHAR_SIZE = 767;
    private static final int VARCHAR_SIZE = 4000;

    public SqlGenerator(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public String getCreateTableSql(String tableName, ModelMetadata modelMetadata) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE IF NOT EXISTS ").append(tableName).append(" (\n");
        sb.append("  id VARCHAR(767) PRIMARY KEY,\n");
        sb.append("  visibility VARCHAR(4000) NOT NULL,\n");
        boolean first = true;
        for (ModelMetadata.Field oField : modelMetadata.getFields()) {
            if (!first) {
                sb.append(",\n");
            }
            ModelMetadata.Field field = oField;
            String columnName = this.getColumnName(field);
            String sqlType = this.getSqlType(field);
            sb.append("  ").append(columnName).append(" ").append(sqlType);
            first = false;
        }
        sb.append("\n);");
        return sb.toString();
    }

    private String getSqlType(ModelMetadata.Field field) {
        if (field instanceof ModelMetadata.StringField) {
            return "TEXT";
        }
        if (field instanceof ModelMetadata.LongField) {
            return "BIGINT";
        }
        if (field instanceof ModelMetadata.IntegerField) {
            return "INTEGER";
        }
        if (field instanceof ModelMetadata.DateField) {
            return "TIMESTAMP";
        }
        if (field instanceof ModelMetadata.EnumField) {
            return "VARCHAR(4000)";
        }
        if (field instanceof ModelMetadata.JSONObjectField) {
            return "TEXT";
        }
        if (field instanceof ModelMetadata.ObjectField || field instanceof ModelMetadata.ByteArrayField) {
            return "LONGBLOB";
        }
        if (field instanceof ModelMetadata.BooleanField) {
            return "BOOLEAN";
        }
        throw new SimpleOrmException("Could not get sql field type of: " + field.getClass().getName());
    }

    public String getColumnName(ModelMetadata.Field field) {
        if (field instanceof ModelMetadata.IdField) {
            return "id";
        }
        String columnFamily = field.getColumnFamily();
        String columnName = field.getColumnName();
        return this.getColumnName(columnFamily, columnName);
    }

    public String getColumnName(String columnFamily, String columnName) {
        StringBuilder result = new StringBuilder();
        if (columnFamily != null && columnFamily.length() > 0) {
            result.append(columnFamily).append('_');
        }
        if (columnName != null && columnName.length() > 0) {
            result.append(columnName);
        }
        return result.toString();
    }

    public <T> String getTableName(ModelMetadata<T> modelMetadata) {
        return this.tablePrefix + modelMetadata.getTableName();
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public String getDropTableSql(String tableName) {
        return String.format(SQL_DROP_TABLE, tableName);
    }

    public String getClearTableSql(String tableName) {
        return String.format(SQL_CLEAR_TABLE, tableName);
    }

    public <T> String getFindAllSql(ModelMetadata<T> modelMetadata) {
        return String.format(SQL_FIND_ALL, this.getTableName(modelMetadata));
    }

    public <T> String getFindByIdSql(ModelMetadata<T> modelMetadata) {
        return String.format(SQL_FIND_BY_ID, this.getTableName(modelMetadata));
    }

    public <T> String getFindByIdStartsWithSql(ModelMetadata<T> modelMetadata) {
        return String.format(SQL_FIND_BY_ID_STARTS_WITH, this.getTableName(modelMetadata));
    }

    public <T> String getUpdateSql(ModelMetadata<T> modelMetadata, Collection<ModelMetadata.Field> allFields) {
        StringBuilder result = new StringBuilder();
        result.append("UPDATE ").append(this.getTableName(modelMetadata)).append(" SET visibility=?");
        for (ModelMetadata.Field field : allFields) {
            result.append(",").append(this.getColumnName(field)).append("=?");
        }
        result.append(" WHERE id=?");
        return result.toString();
    }

    public <T> String getInsertSql(ModelMetadata<T> modelMetadata, Collection<ModelMetadata.Field> allFields) {
        StringBuilder result = new StringBuilder();
        result.append("INSERT INTO ").append(this.getTableName(modelMetadata)).append(" (id,visibility");
        for (ModelMetadata.Field field : allFields) {
            result.append(",").append(this.getColumnName(field));
        }
        result.append(") VALUES (?,?");
        for (ModelMetadata.Field field : allFields) {
            result.append(",?");
        }
        result.append(")");
        return result.toString();
    }

    public <T> String getDeleteByIdSql(ModelMetadata<T> modelMetadata) {
        return String.format(SQL_DELETE, this.getTableName(modelMetadata));
    }
}

