/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.orm.sql;

import com.mware.core.orm.ModelMetadata;
import com.mware.core.orm.SimpleOrmContext;
import com.mware.core.orm.SimpleOrmException;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.orm.sql.SqlGenerator;
import com.mware.core.orm.sql.SqlSimpleOrmContext;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSimpleOrmSession
extends SimpleOrmSession {
    private static final int TABLE_NAME_COLUMN = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlSimpleOrmSession.class);
    private static final String CONFIG_PREFIX = "simpleOrm.sql.";
    private final Set<String> existingTables = new HashSet<String>();
    private SqlGenerator sqlGenerator;
    private DataSource dataSource;

    public void init(Map<String, Object> properties) {
        this.dataSource = this.createDataSource(properties);
        this.sqlGenerator = new SqlGenerator(SqlSimpleOrmSession.getTablePrefix(properties));
    }

    private DataSource createDataSource(Map<String, Object> config) {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> configEntry : config.entrySet()) {
            String key = configEntry.getKey();
            if (!key.startsWith(CONFIG_PREFIX)) continue;
            key = key.substring(CONFIG_PREFIX.length());
            properties.put(key, configEntry.getValue());
        }
        HikariConfig hikariConfig = new HikariConfig(properties);
        return new HikariDataSource(hikariConfig);
    }

    private static String getTablePrefix(Map<String, Object> properties) {
        String tablePrefix = (String)properties.get("simpleOrm.tablePrefix");
        if (tablePrefix == null) {
            tablePrefix = "";
        }
        return tablePrefix;
    }

    @Override
    public SimpleOrmContext createContext(String ... authorizations) {
        return new SqlSimpleOrmContext(authorizations);
    }

    @Override
    public String getTablePrefix() {
        return this.sqlGenerator.getTablePrefix();
    }

    public Set<String> getTableList(SimpleOrmContext context) {
        HashSet<String> results = new HashSet<String>();
        try (Connection conn = this.getConnection(context);){
            ResultSet rs = conn.getMetaData().getTables(null, null, "%", null);
            while (rs.next()) {
                String tableName = rs.getString(3);
                results.add(tableName);
            }
        }
        catch (SQLException e) {
            throw new SimpleOrmException("Failed to get table names", e);
        }
        return results;
    }

    @Override
    public void deleteTable(String tableName, SimpleOrmContext context) {
        try (Connection conn = this.getConnection(context);){
            String sql = this.sqlGenerator.getDropTableSql(tableName);
            LOGGER.debug("sql: " + sql);
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new SimpleOrmException("Failed to delete table", e);
        }
    }

    @Override
    public void clearTable(String table, SimpleOrmContext context) {
        try (Connection conn = this.getConnection(context);){
            String sql = this.sqlGenerator.getClearTableSql(table);
            LOGGER.debug("sql: " + sql);
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new SimpleOrmException("Failed to clear table", e);
        }
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> rowClass, SimpleOrmContext context) {
        ModelMetadata<Class<T>> modelMetadata = this.getModelMetadata(context, (T)rowClass);
        try {
            Connection conn = this.getConnection(context);
            String sql = this.sqlGenerator.getFindAllSql(modelMetadata);
            LOGGER.debug("sql: " + sql);
            PreparedStatement stmt = conn.prepareStatement(sql);
            return this.resultSetToRows(modelMetadata, conn, stmt.executeQuery());
        }
        catch (SQLException e) {
            throw new SimpleOrmException("Failed to find all", e);
        }
    }

    @Override
    public <T> Iterable<T> findAllInRange(String startKey, String endKey, Class<T> rowClass, SimpleOrmContext context) {
        throw new UnsupportedOperationException("not implemented");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> T findById(Class<T> rowClass, String id, SimpleOrmContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <T> Iterable<T> findByIdStartsWith(Class<T> rowClass, String idPrefix, SimpleOrmContext context) {
        ModelMetadata<Class<T>> modelMetadata = this.getModelMetadata(context, (T)rowClass);
        try {
            Connection conn = this.getConnection(context);
            String sql = this.sqlGenerator.getFindByIdStartsWithSql(modelMetadata);
            LOGGER.debug("sql: " + sql);
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.setString(1, idPrefix + "%");
            return this.resultSetToRows(modelMetadata, conn, stmt.executeQuery());
        }
        catch (SQLException e) {
            throw new SimpleOrmException("Failed to find by id starts with: " + idPrefix, e);
        }
    }

    @Override
    public <T> void save(T obj, String visibility, SimpleOrmContext context) {
        String sql;
        boolean isInsert;
        ModelMetadata<T> modelMetadata = this.getModelMetadata(context, obj);
        ModelMetadata.Type modelMetadataType = modelMetadata.getTypeFromObject(obj);
        Collection<ModelMetadata.Field> allFields = modelMetadataType.getAllFields();
        String objId = modelMetadata.getId(obj);
        Object existingObj = this.findById(obj.getClass(), objId, context);
        if (existingObj != null) {
            isInsert = false;
            sql = this.sqlGenerator.getUpdateSql(modelMetadata, allFields);
        } else {
            isInsert = true;
            sql = this.sqlGenerator.getInsertSql(modelMetadata, allFields);
        }
        try (Connection conn = this.getConnection(context);){
            LOGGER.debug("sql: " + sql);
            PreparedStatement stmt = conn.prepareStatement(sql);
            int i = 1;
            if (isInsert) {
                stmt.setString(i++, objId);
            }
            stmt.setString(i++, visibility);
            for (ModelMetadata.Field field : allFields) {
                Object raw;
                if (field instanceof ModelMetadata.StringField) {
                    stmt.setString(i, (String)((ModelMetadata.StringField)field).getRaw(obj));
                } else if (field instanceof ModelMetadata.JSONObjectField) {
                    raw = (JSONObject)((ModelMetadata.JSONObjectField)field).getRaw(obj);
                    stmt.setString(i, raw == null ? null : raw.toString());
                } else if (field instanceof ModelMetadata.EnumField) {
                    raw = (Enum)((ModelMetadata.EnumField)field).getRaw(obj);
                    stmt.setString(i, raw == null ? null : ((Enum)raw).name());
                } else if (field instanceof ModelMetadata.IntegerField) {
                    if (!this.setIfNullValue(stmt, i, field, 4, obj)) {
                        stmt.setInt(i, (Integer)((ModelMetadata.IntegerField)field).getRaw(obj));
                    }
                } else if (field instanceof ModelMetadata.BooleanField) {
                    if (!this.setIfNullValue(stmt, i, field, 16, obj)) {
                        stmt.setBoolean(i, (Boolean)((ModelMetadata.BooleanField)field).getRaw(obj));
                    }
                } else if (field instanceof ModelMetadata.LongField) {
                    if (!this.setIfNullValue(stmt, i, field, 4, obj)) {
                        stmt.setLong(i, (Long)((ModelMetadata.LongField)field).getRaw(obj));
                    }
                } else if (field instanceof ModelMetadata.DateField) {
                    raw = (Date)((ModelMetadata.DateField)field).getRaw(obj);
                    stmt.setTimestamp(i, raw == null ? null : new Timestamp(((Date)raw).getTime()));
                } else if (field instanceof ModelMetadata.ObjectField || field instanceof ModelMetadata.ByteArrayField) {
                    raw = field.get(obj);
                    if (raw == null) {
                        stmt.setBlob(i, (InputStream)null);
                    } else {
                        ByteArrayInputStream blobData = new ByteArrayInputStream((byte[])raw);
                        stmt.setBinaryStream(i, (InputStream)blobData, ((Object)raw).length);
                    }
                } else {
                    throw new SimpleOrmException("Could not store field: " + field.getClass().getName());
                }
                ++i;
            }
            if (!isInsert) {
                stmt.setString(i, objId);
            }
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new SimpleOrmException("Failed to insert: " + obj, e);
        }
    }

    private boolean setIfNullValue(PreparedStatement stmt, int paramIndex, ModelMetadata.Field field, int sqlType, Object obj) throws SQLException {
        Object raw = field.getRaw(obj);
        if (raw == null) {
            stmt.setNull(paramIndex, sqlType, null);
            return true;
        }
        return false;
    }

    @Override
    public <T> void delete(Class<T> rowClass, String id, SimpleOrmContext context) {
        ModelMetadata<Class<T>> modelMetadata = this.getModelMetadata(context, (T)rowClass);
        try (Connection conn = this.getConnection(context);){
            String sql = this.sqlGenerator.getDeleteByIdSql(modelMetadata);
            LOGGER.debug("sql: " + sql);
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new SimpleOrmException("Failed to delete: " + id, e);
        }
    }

    @Override
    public void close() {
    }

    public Connection getConnection(SimpleOrmContext context) throws SQLException {
        return this.dataSource.getConnection();
    }

    private void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    private <T> ClosableIterable<T> resultSetToRows(final ModelMetadata<T> modelMetadata, final Connection conn, final ResultSet resultSet) throws SQLException {
        final ResultSetMetaData resultSetMetadata = resultSet.getMetaData();
        final String discriminatorColumnName = modelMetadata.getDiscriminatorColumnFamily() != null || modelMetadata.getDiscriminatorColumnName() != null ? this.sqlGenerator.getColumnName(modelMetadata.getDiscriminatorColumnFamily(), modelMetadata.getDiscriminatorColumnName()) : null;
        final ModelMetadata.Type defaultType = modelMetadata.getType(null);
        return new ClosableIterable<T>(){

            @Override
            public ClosableIterator<T> iterator() {
                return new ClosableIterator<T>(){
                    private T next;

                    @Override
                    public boolean hasNext() {
                        try {
                            this.fetchNext();
                        }
                        catch (Exception e) {
                            throw new SimpleOrmException("Could not fetch next", e);
                        }
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        Object result = this.next;
                        this.next = null;
                        return result;
                    }

                    @Override
                    public void close() {
                        try {
                            if (!resultSet.isClosed()) {
                                resultSet.close();
                            }
                            if (conn != null && !conn.isClosed()) {
                                SqlSimpleOrmSession.this.closeConnection(conn);
                            }
                        }
                        catch (Exception ex) {
                            throw new SimpleOrmException("Could not close iterable", ex);
                        }
                    }

                    private void fetchNext() throws SQLException, IOException {
                        ModelMetadata.Type type;
                        if (this.next != null || resultSet.isClosed()) {
                            return;
                        }
                        if (!resultSet.next()) {
                            this.close();
                            return;
                        }
                        if (discriminatorColumnName != null) {
                            String discriminatorValue = resultSet.getString(discriminatorColumnName);
                            type = modelMetadata.getType(discriminatorValue);
                        } else {
                            type = defaultType;
                        }
                        Collection<ModelMetadata.Field> fields = type.getAllFields();
                        Object result = type.newInstance();
                        modelMetadata.setIdField(result, resultSet.getString("id"));
                        for (int i = 1; i <= resultSetMetadata.getColumnCount(); ++i) {
                            String columnLabel = resultSetMetadata.getColumnLabel(i);
                            ModelMetadata.Field field = this.findFieldByColumnName(fields, columnLabel);
                            try {
                                String str;
                                if (field == null) continue;
                                if (field instanceof ModelMetadata.StringField) {
                                    field.setRaw(result, resultSet.getString(i));
                                    continue;
                                }
                                if (field instanceof ModelMetadata.EnumField) {
                                    str = resultSet.getString(i);
                                    field.set(result, str == null ? null : str.getBytes());
                                    continue;
                                }
                                if (field instanceof ModelMetadata.LongField) {
                                    long rsLong = resultSet.getLong(i);
                                    boolean wasNull = resultSet.wasNull();
                                    field.setRaw(result, wasNull ? null : Long.valueOf(rsLong));
                                    continue;
                                }
                                if (field instanceof ModelMetadata.IntegerField) {
                                    int rsInt = resultSet.getInt(i);
                                    boolean wasNull = resultSet.wasNull();
                                    field.setRaw(result, wasNull ? null : Integer.valueOf(rsInt));
                                    continue;
                                }
                                if (field instanceof ModelMetadata.BooleanField) {
                                    boolean rsBoolean = resultSet.getBoolean(i);
                                    boolean wasNull = resultSet.wasNull();
                                    field.setRaw(result, wasNull ? null : Boolean.valueOf(rsBoolean));
                                    continue;
                                }
                                if (field instanceof ModelMetadata.DateField) {
                                    Timestamp timestamp = resultSet.getTimestamp(i);
                                    field.setRaw(result, timestamp == null ? null : new Date(timestamp.getTime()));
                                    continue;
                                }
                                if (field instanceof ModelMetadata.JSONObjectField) {
                                    str = resultSet.getString(i);
                                    field.setRaw(result, str == null ? null : new JSONObject(str));
                                    continue;
                                }
                                if (field instanceof ModelMetadata.ObjectField || field instanceof ModelMetadata.ByteArrayField) {
                                    InputStream value = resultSet.getBinaryStream(i);
                                    if (value == null) {
                                        field.set(result, null);
                                        continue;
                                    }
                                    byte[] raw = IOUtils.toByteArray((InputStream)value);
                                    field.set(result, raw);
                                    continue;
                                }
                                throw new SimpleOrmException("Could not populate field of type: " + field.getClass());
                            }
                            catch (Exception ex) {
                                throw new SimpleOrmException("Could not read sql column: " + columnLabel + " into field: " + field, ex);
                            }
                        }
                        this.next = result;
                    }

                    private ModelMetadata.Field findFieldByColumnName(Collection<ModelMetadata.Field> fields, String columnLabel) {
                        for (ModelMetadata.Field field : fields) {
                            if (!SqlSimpleOrmSession.this.sqlGenerator.getColumnName(field).equalsIgnoreCase(columnLabel)) continue;
                            return field;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new SimpleOrmException("Not supported");
                    }
                };
            }
        };
    }

    private <T> ModelMetadata<T> getModelMetadata(SimpleOrmContext context, Class<T> rowClass) {
        ModelMetadata<Class<T>> modelMetadata = ModelMetadata.getModelMetadata(rowClass);
        this.createTableIfNotExists(context, modelMetadata);
        return modelMetadata;
    }

    private <T> ModelMetadata<T> getModelMetadata(SimpleOrmContext context, T rowObject) {
        ModelMetadata<T> modelMetadata = ModelMetadata.getModelMetadata(rowObject);
        this.createTableIfNotExists(context, modelMetadata);
        return modelMetadata;
    }

    private <T> void createTableIfNotExists(SimpleOrmContext context, ModelMetadata<T> modelMetadata) {
        String tableName;
        if (this.existingTables.size() == 0) {
            this.existingTables.addAll((Collection<String>)this.getTableList(context));
        }
        if (!this.existingTables.contains(tableName = this.sqlGenerator.getTableName(modelMetadata))) {
            LOGGER.info("Table \"" + tableName + "\" not found. Creating...");
            try (Connection conn = this.getConnection(context);){
                String sql = this.sqlGenerator.getCreateTableSql(tableName, modelMetadata);
                LOGGER.debug(sql);
                PreparedStatement stmt = conn.prepareStatement(sql);
                stmt.execute();
                this.existingTables.add(tableName);
            }
            catch (Exception ex) {
                throw new SimpleOrmException("Could not create table: " + tableName, ex);
            }
        }
    }

    private static interface ClosableIterator<T>
    extends Iterator<T>,
    AutoCloseable {
    }

    private static interface ClosableIterable<T>
    extends Iterable<T> {
        @Override
        public ClosableIterator<T> iterator();
    }
}

