/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ping;

import com.google.inject.Inject;
import com.mware.core.ingest.dataworker.DataWorker;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.ping.PingUtil;
import com.mware.ge.Element;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import java.io.InputStream;

@Name(value="Ping")
@Description(value="work on special Ping vertices to measure Data Worker wait time")
public class PingDataWorker
extends DataWorker {
    private final PingUtil pingUtil;

    @Inject
    public PingDataWorker(PingUtil pingUtil) {
        this.pingUtil = pingUtil;
    }

    @Override
    public void execute(InputStream in, DataWorkerData data) throws Exception {
        Vertex vertex = (Vertex)data.getElement();
        this.pingUtil.gpwUpdate(vertex, this.getGraph(), this.getAuthorizations());
    }

    @Override
    public boolean isHandled(Element element, Property property) {
        return element instanceof Vertex && "__p".equals(((Vertex)element).getConceptType()) && property == null;
    }
}

