/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ping;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.longRunningProcess.LongRunningProcessWorker;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.ping.PingLongRunningProcessQueueItem;
import com.mware.core.ping.PingUtil;
import com.mware.core.util.ClientApiConverter;
import com.mware.ge.Authorizations;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import org.json.JSONObject;

@Name(value="Ping")
@Description(value="run on special Ping vertices to measure LRP wait time")
@Singleton
public class PingLongRunningProcess
extends LongRunningProcessWorker {
    private final UserRepository userRepository;
    private final Graph graph;
    private final PingUtil pingUtil;
    private final AuthorizationRepository authorizationRepository;

    @Inject
    public PingLongRunningProcess(AuthorizationRepository authorizationRepository, UserRepository userRepository, Graph graph, PingUtil pingUtil) {
        this.authorizationRepository = authorizationRepository;
        this.userRepository = userRepository;
        this.graph = graph;
        this.pingUtil = pingUtil;
    }

    @Override
    protected void processInternal(JSONObject jsonObject) {
        PingLongRunningProcessQueueItem queueItem = ClientApiConverter.toClientApi(jsonObject.toString(), PingLongRunningProcessQueueItem.class);
        Authorizations authorizations = this.authorizationRepository.getGraphAuthorizations(this.userRepository.getSystemUser(), new String[0]);
        Vertex vertex = this.graph.getVertex(queueItem.getVertexId(), authorizations);
        this.pingUtil.lrpUpdate(vertex, this.graph, authorizations);
    }

    @Override
    public boolean isHandled(JSONObject jsonObject) {
        return PingLongRunningProcessQueueItem.isHandled(jsonObject);
    }
}

