/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ping;

import com.google.common.base.Strings;
import com.mware.core.model.properties.types.DateSingleValueBcProperty;
import com.mware.core.model.properties.types.LongSingleValueBcProperty;
import com.mware.core.model.properties.types.StringSingleValueBcProperty;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;

public class PingSchema {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String HOST_NAME = PingSchema.getHostName();
    public static final String BASE_NAME = "ping";
    public static final String CONCEPT_NAME_PING = "__p";
    public static final DateSingleValueBcProperty CREATE_DATE = new DateSingleValueBcProperty("pingCreateDate");
    public static final StringSingleValueBcProperty CREATE_REMOTE_ADDR = new StringSingleValueBcProperty("pingCreateRemoteAddr");
    public static final LongSingleValueBcProperty SEARCH_TIME_MS = new LongSingleValueBcProperty("pingSearchTimeMs");
    public static final LongSingleValueBcProperty RETRIEVAL_TIME_MS = new LongSingleValueBcProperty("pingRetrievalTimeMs");
    public static final DateSingleValueBcProperty GRAPH_PROPERTY_WORKER_DATE = new DateSingleValueBcProperty("pingGpwDate");
    public static final StringSingleValueBcProperty GRAPH_PROPERTY_WORKER_HOSTNAME = new StringSingleValueBcProperty("pingGpwHostname");
    public static final StringSingleValueBcProperty GRAPH_PROPERTY_WORKER_HOST_ADDRESS = new StringSingleValueBcProperty("pingGpwHostAddress");
    public static final LongSingleValueBcProperty GRAPH_PROPERTY_WORKER_WAIT_TIME_MS = new LongSingleValueBcProperty("pingGpwWaitTimeMs");
    public static final DateSingleValueBcProperty LONG_RUNNING_PROCESS_DATE = new DateSingleValueBcProperty("pingLrpDate");
    public static final StringSingleValueBcProperty LONG_RUNNING_PROCESS_HOSTNAME = new StringSingleValueBcProperty("pingLrpHostname");
    public static final StringSingleValueBcProperty LONG_RUNNING_PROCESS_HOST_ADDRESS = new StringSingleValueBcProperty("pingLrpHostAddress");
    public static final LongSingleValueBcProperty LONG_RUNNING_PROCESS_WAIT_TIME_MS = new LongSingleValueBcProperty("pingLrpWaitTimeMs");

    public static String getVertexId(ZonedDateTime date) {
        return "PING_" + new SimpleDateFormat(DATE_TIME_FORMAT).format(date) + "_" + HOST_NAME;
    }

    private static String getHostName() {
        String host = System.getenv("COMPUTERNAME");
        if (!Strings.isNullOrEmpty((String)host)) {
            return host;
        }
        host = System.getenv("HOSTNAME");
        if (!Strings.isNullOrEmpty((String)host)) {
            return host;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            return "Unknown";
        }
    }
}

