/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ping;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.exception.BcException;
import com.mware.core.ingest.dataworker.ElementOrPropertyStatus;
import com.mware.core.model.longRunningProcess.LongRunningProcessRepository;
import com.mware.core.model.user.GraphAuthorizationRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.workQueue.Priority;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.ping.PingLongRunningProcessQueueItem;
import com.mware.core.ping.PingSchema;
import com.mware.core.security.BcVisibility;
import com.mware.core.security.VisibilityTranslator;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingVertexMutation;
import com.mware.ge.query.Compare;
import com.mware.ge.query.Predicate;
import com.mware.ge.query.Query;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.aggregations.StatisticsAggregation;
import com.mware.ge.query.aggregations.StatisticsResult;
import com.mware.ge.values.storable.Values;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import org.json.JSONObject;

@Singleton
public class PingUtil {
    public static final String VISIBILITY_STRING = "ping";
    public static final Visibility VISIBILITY = new BcVisibility("ping").getVisibility();
    private final User systemUser;
    private final VisibilityTranslator visibilityTranslator;

    @Inject
    public PingUtil(GraphAuthorizationRepository graphAuthorizationRepository, UserRepository userRepository, VisibilityTranslator visibilityTranslator) {
        graphAuthorizationRepository.addAuthorizationToGraph(VISIBILITY_STRING);
        this.systemUser = userRepository.getSystemUser();
        this.visibilityTranslator = visibilityTranslator;
    }

    public String search(Graph graph, Authorizations authorizations) {
        Query query = graph.query(authorizations).limit(1);
        ArrayList vertices = Lists.newArrayList(query.vertices());
        if (vertices.size() == 0) {
            throw new BcException("query returned no vertices");
        }
        if (vertices.size() > 1) {
            throw new BcException("query returned more than one vertex");
        }
        return ((Vertex)vertices.get(0)).getId();
    }

    public void retrieve(String vertexId, Graph graph, Authorizations authorizations) {
        Vertex retrievedVertex = graph.getVertex(vertexId, authorizations);
        if (retrievedVertex == null) {
            throw new BcException("failed to retrieve vertex by id: " + vertexId);
        }
    }

    public Vertex createVertex(String remoteAddr, long searchTime, long retrievalTime, Graph graph, Authorizations authorizations) {
        ZonedDateTime createDate = ZonedDateTime.now();
        String vertexId = PingSchema.getVertexId(createDate);
        VertexBuilder mutation = graph.prepareVertex(vertexId, VISIBILITY, "__p");
        PingSchema.CREATE_DATE.setProperty(mutation, createDate, VISIBILITY);
        PingSchema.CREATE_REMOTE_ADDR.setProperty(mutation, remoteAddr, VISIBILITY);
        PingSchema.SEARCH_TIME_MS.setProperty(mutation, searchTime, VISIBILITY);
        PingSchema.RETRIEVAL_TIME_MS.setProperty(mutation, retrievalTime, VISIBILITY);
        Vertex vertex = (Vertex)mutation.save(authorizations);
        graph.flush();
        return vertex;
    }

    public void enqueueToWorkQueue(Vertex vertex, WorkQueueRepository workQueueRepository, WebQueueRepository webQueueRepository, Priority priority) {
        if (webQueueRepository.shouldBroadcast(priority)) {
            webQueueRepository.broadcastPropertyChange(vertex, null, null, null);
        }
        workQueueRepository.pushGraphPropertyQueue(vertex, null, null, null, null, priority, ElementOrPropertyStatus.UPDATE, null);
    }

    public void gpwUpdate(Vertex vertex, Graph graph, Authorizations authorizations) {
        ZonedDateTime updateDate = ZonedDateTime.now();
        Long waitTimeMs = updateDate.toInstant().toEpochMilli() - ((ZonedDateTime)PingSchema.CREATE_DATE.getPropertyValueRequired(vertex)).toInstant().toEpochMilli();
        ExistingVertexMutation mutation = vertex.prepareMutation();
        PingSchema.GRAPH_PROPERTY_WORKER_DATE.setProperty(mutation, updateDate, VISIBILITY);
        PingSchema.GRAPH_PROPERTY_WORKER_HOSTNAME.setProperty(mutation, this.getHostname(), VISIBILITY);
        PingSchema.GRAPH_PROPERTY_WORKER_HOST_ADDRESS.setProperty(mutation, this.getHostAddress(), VISIBILITY);
        PingSchema.GRAPH_PROPERTY_WORKER_WAIT_TIME_MS.setProperty(mutation, waitTimeMs, VISIBILITY);
        mutation.save(authorizations);
        graph.flush();
    }

    public void enqueueToLongRunningProcess(Vertex vertex, LongRunningProcessRepository longRunningProcessRepository, Authorizations authorizations) {
        longRunningProcessRepository.enqueue(new PingLongRunningProcessQueueItem(vertex).toJson(), this.systemUser, authorizations);
    }

    public void lrpUpdate(Vertex vertex, Graph graph, Authorizations authorizations) {
        ZonedDateTime updateDate = ZonedDateTime.now();
        Long waitTimeMs = updateDate.toInstant().toEpochMilli() - ((ZonedDateTime)PingSchema.CREATE_DATE.getPropertyValueRequired(vertex)).toInstant().toEpochMilli();
        ExistingVertexMutation mutation = vertex.prepareMutation();
        PingSchema.LONG_RUNNING_PROCESS_DATE.setProperty(mutation, updateDate, VISIBILITY);
        PingSchema.LONG_RUNNING_PROCESS_HOSTNAME.setProperty(mutation, this.getHostname(), VISIBILITY);
        PingSchema.LONG_RUNNING_PROCESS_HOST_ADDRESS.setProperty(mutation, this.getHostAddress(), VISIBILITY);
        PingSchema.LONG_RUNNING_PROCESS_WAIT_TIME_MS.setProperty(mutation, waitTimeMs, VISIBILITY);
        mutation.save(authorizations);
        graph.flush();
    }

    public JSONObject getAverages(int minutes, Graph graph, Authorizations authorizations) {
        ZonedDateTime minutesAgo = ZonedDateTime.now().minusMinutes(60L);
        Query q = graph.query(authorizations).hasConceptType("__p").has(PingSchema.CREATE_DATE.getPropertyName(), (Predicate)Compare.GREATER_THAN, Values.temporalValue(minutesAgo)).limit(0);
        q.addAggregation(new StatisticsAggregation(PingSchema.SEARCH_TIME_MS.getPropertyName(), PingSchema.SEARCH_TIME_MS.getPropertyName()));
        q.addAggregation(new StatisticsAggregation(PingSchema.RETRIEVAL_TIME_MS.getPropertyName(), PingSchema.RETRIEVAL_TIME_MS.getPropertyName()));
        q.addAggregation(new StatisticsAggregation(PingSchema.GRAPH_PROPERTY_WORKER_WAIT_TIME_MS.getPropertyName(), PingSchema.GRAPH_PROPERTY_WORKER_WAIT_TIME_MS.getPropertyName()));
        q.addAggregation(new StatisticsAggregation(PingSchema.LONG_RUNNING_PROCESS_WAIT_TIME_MS.getPropertyName(), PingSchema.LONG_RUNNING_PROCESS_WAIT_TIME_MS.getPropertyName()));
        QueryResultsIterable<Vertex> vertices = q.vertices();
        StatisticsResult searchTimeAgg = vertices.getAggregationResult(PingSchema.SEARCH_TIME_MS.getPropertyName(), StatisticsResult.class);
        StatisticsResult retrievalTimeAgg = vertices.getAggregationResult(PingSchema.RETRIEVAL_TIME_MS.getPropertyName(), StatisticsResult.class);
        StatisticsResult gpwWaitTimeAgg = vertices.getAggregationResult(PingSchema.GRAPH_PROPERTY_WORKER_WAIT_TIME_MS.getPropertyName(), StatisticsResult.class);
        StatisticsResult lrpWaitTimeAgg = vertices.getAggregationResult(PingSchema.LONG_RUNNING_PROCESS_WAIT_TIME_MS.getPropertyName(), StatisticsResult.class);
        JSONObject json = new JSONObject();
        json.put("pingCount", searchTimeAgg.getCount());
        json.put("averageSearchTime", searchTimeAgg.getAverage());
        json.put("averageRetrievalTime", retrievalTimeAgg.getAverage());
        json.put("graphPropertyWorkerCount", gpwWaitTimeAgg.getCount());
        json.put("averageGraphPropertyWorkerWaitTime", gpwWaitTimeAgg.getAverage());
        json.put("longRunningProcessCount", lrpWaitTimeAgg.getCount());
        json.put("averageLongRunningProcessWaitTime", lrpWaitTimeAgg.getAverage());
        return json;
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
    }

    private String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
    }
}

