/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.process;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.config.Configurable;
import com.mware.core.config.Configuration;
import com.mware.core.ingest.dataworker.DataWorkerRunner;
import com.mware.core.lifecycle.LifeSupportService;
import com.mware.core.lifecycle.LifecycleAdapter;
import com.mware.core.user.SystemUser;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.StoppableRunnable;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class DataWorkerRunnerProcess
extends LifecycleAdapter {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(DataWorkerRunnerProcess.class);
    private final Config config;
    private final List<StoppableRunnable> stoppables = new ArrayList<StoppableRunnable>();

    @Inject
    public DataWorkerRunnerProcess(Configuration configuration, LifeSupportService lifeSupportService) {
        this(configuration.setConfigurables(new Config(), DataWorkerRunnerProcess.class.getName()));
        lifeSupportService.add(this);
    }

    public DataWorkerRunnerProcess(Config config) {
        this.config = config;
    }

    @Override
    public void start() {
        if (this.config.threadCount <= 0) {
            LOGGER.info("'threadCount' not configured or was 0", new Object[0]);
            return;
        }
        this.stoppables.addAll(DataWorkerRunner.startThreaded(this.config.threadCount, new SystemUser()));
    }

    @Override
    public void shutdown() {
        this.stoppables.forEach(StoppableRunnable::stop);
    }

    public static class Config {
        @Configurable
        public int threadCount;
    }
}

