/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.process;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mware.core.process.ProcessDiedException;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ProcessUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;

public class ExecUtils {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(ExecUtils.class);

    public static void unsafeSleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public static byte[] execAndGetOutput(ProcessBuilder pb) throws IOException, InterruptedException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(outputCollector).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withCompletionHandler(new SimpleExceptionExecCompletionHandler(pb.command())).exec();
        return outputCollector.getCollected();
    }

    public static byte[] execAndLogAndGetOutput(ProcessBuilder pb, File log) throws IOException, InterruptedException {
        try (FileOutputStream os = new FileOutputStream(log, true);){
            ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
            OutputStreamSubscription osSubscription = new OutputStreamSubscription(os, false);
            new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(outputCollector).withOutputConsumer(osSubscription).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(osSubscription).withCompletionHandler(new SimpleExceptionExecCompletionHandler(pb.command())).exec();
            byte[] byArray = outputCollector.getCollected();
            return byArray;
        }
    }

    public static ExecutionResults execAndGetOutputAndErrors(ProcessBuilder pb) throws InterruptedException, IOException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        ByteCollectingSubscription errorCollector = new ByteCollectingSubscription();
        ExecutionResults er = new ExecutionResults();
        er.rv = new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(outputCollector).withErrorConsumer(errorCollector).exec();
        er.out = new String(outputCollector.getCollected(), StandardCharsets.UTF_8);
        er.err = new String(errorCollector.getCollected(), StandardCharsets.UTF_8);
        return er;
    }

    public static ExecutionResults execAndGetOutputAndErrors(String[] args, Map<String, String> env) throws InterruptedException, IOException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        ByteCollectingSubscription errorCollector = new ByteCollectingSubscription();
        ExecutionResults er = new ExecutionResults();
        er.rv = new ExecBuilder().withArgs(args).withEnv(env).withOutputConsumer(outputCollector).withErrorConsumer(errorCollector).exec();
        er.out = new String(outputCollector.getCollected(), StandardCharsets.UTF_8);
        er.err = new String(errorCollector.getCollected(), StandardCharsets.UTF_8);
        return er;
    }

    public static class ExecutionResults {
        public String out;
        public String err;
        public int rv;
    }

    public static class SimpleExceptionExecCompletionHandler
    implements ExecCompletionHandler {
        private String commandName;
        private String message;

        public SimpleExceptionExecCompletionHandler() {
        }

        public SimpleExceptionExecCompletionHandler(String message) {
            this.message = message;
        }

        public SimpleExceptionExecCompletionHandler(List<String> command) {
            if (!command.isEmpty() && command.get(0).length() < 100) {
                this.commandName = command.get(0);
            }
        }

        @Override
        public void init(ExecBuilder builder) {
        }

        @Override
        public void handle(int rv) throws IOException {
            if (rv != 0) {
                throw ProcessDiedException.getExceptionOnProcessDeath(this.commandName + " failed", null, false, rv);
            }
        }
    }

    public static class LoggingLineSubscription
    implements LineSubscription {
        private final Level level;

        public LoggingLineSubscription(Level level) {
            this.level = level;
        }

        @Override
        public void handle(String line, boolean replace) {
            if (this.level.equals((Object)Level.INFO) || this.level.equals((Object)Level.ALL)) {
                LOGGER.info(line, new Object[0]);
            } else if (this.level.equals((Object)Level.WARN)) {
                LOGGER.warn(line, new Object[0]);
            } else if (this.level.equals((Object)Level.ERROR) || this.level.equals((Object)Level.FATAL)) {
                LOGGER.error(line, new Object[0]);
            } else if (this.level.equals((Object)Level.DEBUG)) {
                LOGGER.debug(line, new Object[0]);
            } else if (this.level.equals((Object)Level.TRACE)) {
                LOGGER.trace(line, new Object[0]);
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class OutputWriterSubscription
    implements LineSubscription {
        private final Writer wr;
        private final boolean doCloseWriter;

        public OutputWriterSubscription(Writer wr, boolean doCloseWriter) {
            this.wr = wr;
            this.doCloseWriter = doCloseWriter;
        }

        @Override
        public void handle(String line, boolean replace) throws IOException {
            this.wr.write(line);
            this.wr.write("\n");
            this.wr.flush();
        }

        @Override
        public void close() throws IOException {
            this.wr.flush();
            if (this.doCloseWriter) {
                this.wr.close();
            }
        }
    }

    public static class ByteCollectingSubscription
    implements BytesSubscription {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public byte[] getCollected() {
            return this.baos.toByteArray();
        }

        @Override
        public void handle(byte[] buffer, int count) throws IOException {
            this.baos.write(buffer, 0, count);
        }

        @Override
        public void close() throws IOException {
            this.baos.flush();
        }
    }

    private static class CRLineReader
    extends BufferedReader {
        private static final char LF = '\n';
        private static final char CR = '\r';
        private boolean startsWithCR = false;

        public CRLineReader(Reader reader) {
            super(reader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String readLine() throws IOException {
            StringBuilder sb = new StringBuilder();
            this.startsWithCR = false;
            Object object = this.lock;
            synchronized (object) {
                int intch;
                boolean first = true;
                while ((intch = super.read()) != -1) {
                    if (intch != 13 && intch != 10) {
                        sb.append((char)intch);
                        break;
                    }
                    this.startsWithCR = first && intch == 13;
                    first &= this.startsWithCR;
                }
                while ((intch = this.markAndRead(1)) != -1) {
                    if (intch == 13 || intch == 10) {
                        super.reset();
                        break;
                    }
                    sb.append((char)intch);
                }
            }
            return sb.length() == 0 ? null : sb.toString();
        }

        private int markAndRead(int readAheadLimit) throws IOException {
            super.mark(readAheadLimit);
            return super.read();
        }

        public boolean startsWithCR() {
            return this.startsWithCR;
        }
    }

    private static class StreamDuplicator
    extends Thread {
        private static BcLogger _logger = BcLoggerFactory.getLogger(StreamDuplicator.class);
        private final InputStream src;
        private final List<BytesSubscription> dsts;

        StreamDuplicator(InputStream src, List<BytesSubscription> dsts) {
            this.src = src;
            this.dsts = dsts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object buffer;
            try {
                buffer = new byte[4096];
                int read = this.src.read((byte[])buffer);
                while (read >= 0) {
                    Iterator<BytesSubscription> iterator = this.dsts.iterator();
                    while (iterator.hasNext()) {
                        BytesSubscription dst;
                        BytesSubscription bytesSubscription = dst = iterator.next();
                        synchronized (bytesSubscription) {
                            dst.handle((byte[])buffer, read);
                        }
                    }
                    read = this.src.read((byte[])buffer);
                }
                buffer = this.dsts.iterator();
            }
            catch (IOException e) {
                _logger.error("Failed to duplicate stream", e);
            }
            finally {
                for (BytesSubscription dst : this.dsts) {
                    try {
                        dst.close();
                    }
                    catch (IOException e) {
                        _logger.error("Failed to shutdown output log line handler", e);
                    }
                }
            }
            while (buffer.hasNext()) {
                BytesSubscription dst = (BytesSubscription)buffer.next();
                try {
                    dst.close();
                }
                catch (IOException e) {
                    _logger.error("Failed to shutdown output log line handler", e);
                }
            }
        }
    }

    public static class OutputStreamSubscription
    implements BytesSubscription {
        private final OutputStream os;
        private final boolean doCloseStream;

        public OutputStreamSubscription(OutputStream os, boolean doCloseStream) {
            this.os = os;
            this.doCloseStream = doCloseStream;
        }

        @Override
        public void handle(byte[] buffer, int count) throws IOException {
            this.os.write(buffer, 0, count);
        }

        @Override
        public void close() throws IOException {
            this.os.flush();
            if (this.doCloseStream) {
                this.os.close();
            }
        }
    }

    private static class StreamToLine
    extends Thread {
        private static BcLogger _logger = BcLoggerFactory.getLogger(StreamToLine.class);
        private final InputStream src;
        private final List<LineSubscription> dsts;
        private final String threadBaseName;

        StreamToLine(String threadBaseName, InputStream src, List<LineSubscription> dsts) {
            this.threadBaseName = threadBaseName;
            this.src = src;
            this.dsts = dsts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            Thread.currentThread().setName(this.threadBaseName + "-" + Thread.currentThread().getId());
            try (CRLineReader reader = new CRLineReader(new InputStreamReader(this.src, StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    Iterator<LineSubscription> i$ = this.dsts.iterator();
                    while (i$.hasNext()) {
                        LineSubscription dst;
                        LineSubscription lineSubscription;
                        LineSubscription lineSubscription2 = lineSubscription = (dst = i$.next());
                        synchronized (lineSubscription2) {
                            dst.handle(line, reader.startsWithCR());
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (EOFException e) {
                _logger.debug("StreamToLine: EOF", new Object[0]);
            }
            catch (IOException e) {
                if ("Stream closed".equals(e.getMessage())) {
                    _logger.debug("StreamToLine: EOF (stream closed)", new Object[0]);
                }
                _logger.error("Failed to duplicate stream", e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                for (LineSubscription dst : this.dsts) {
                    try {
                        dst.close();
                    }
                    catch (IOException e) {
                        _logger.error("Failed to shutdown output log line handler", e);
                    }
                }
            }
            for (LineSubscription dst : this.dsts) {
                try {
                    dst.close();
                }
                catch (IOException e) {
                    _logger.error("Failed to shutdown output log line handler", e);
                }
            }
        }
    }

    private static class Blackhole
    extends Thread {
        private final InputStream src;
        private static BcLogger _logger = BcLoggerFactory.getLogger(Blackhole.class);

        Blackhole(InputStream src) {
            this.src = src;
        }

        @Override
        public void run() {
            try {
                long total = 0L;
                byte[] buffer = new byte[4096];
                int read = this.src.read(buffer);
                while (read >= 0) {
                    total += (long)read;
                    read = this.src.read(buffer);
                }
                _logger.info("Read and ignored " + total + " bytes", new Object[0]);
            }
            catch (IOException e) {
                _logger.error("Failed to dev/null stream", e);
            }
        }
    }

    public static class ExecOutputConsumer {
        private String threadsBaseName;
        private List<ExecSubscription> outputConsumers = Lists.newArrayList();
        private List<ExecSubscription> errorConsumers = Lists.newArrayList();
        private String input;
        private List<Thread> outputConsumingThreads;
        private List<Thread> errorConsumingThreads;

        public ExecOutputConsumer withThreadsBaseName(String threadsBaseName) {
            this.threadsBaseName = threadsBaseName;
            return this;
        }

        public ExecOutputConsumer withOutputConsumer(ExecSubscription consumer) {
            this.outputConsumers.add(consumer);
            return this;
        }

        public ExecOutputConsumer withErrorConsumer(ExecSubscription consumer) {
            this.errorConsumers.add(consumer);
            return this;
        }

        public ExecOutputConsumer withOutputConsumers(List<ExecSubscription> consumers) {
            this.outputConsumers.addAll(consumers);
            return this;
        }

        public ExecOutputConsumer withErrorConsumers(List<ExecSubscription> consumers) {
            this.errorConsumers.addAll(consumers);
            return this;
        }

        public ExecOutputConsumer withInput(String input) {
            this.input = input;
            return this;
        }

        public void start(InputStream processOutput, InputStream processError, OutputStream processInput) throws IOException {
            this.outputConsumingThreads = this.build(processOutput, this.threadsBaseName + "-out", this.outputConsumers);
            this.errorConsumingThreads = this.build(processError, this.threadsBaseName + "-err", this.errorConsumers);
            for (Thread t : this.outputConsumingThreads) {
                t.start();
            }
            for (Thread t : this.errorConsumingThreads) {
                t.start();
            }
            if (this.input != null) {
                PrintStream stream = new PrintStream(processInput);
                stream.append(this.input);
                stream.close();
                processInput.close();
            }
        }

        public void finish() throws InterruptedException {
            for (Thread t : this.outputConsumingThreads) {
                t.join();
            }
            for (Thread t : this.errorConsumingThreads) {
                t.join();
            }
        }

        private List<Thread> build(InputStream is, String threadBaseName, List<ExecSubscription> consumers) throws IOException {
            ArrayList bytesSubscription = Lists.newArrayList();
            ArrayList lineSubscriptions = Lists.newArrayList();
            for (ExecSubscription consumer : consumers) {
                if (consumer instanceof BytesSubscription) {
                    bytesSubscription.add(consumer);
                    continue;
                }
                if (consumer instanceof LineSubscription) {
                    lineSubscriptions.add(consumer);
                    continue;
                }
                throw new IllegalArgumentException("Unhandled process output stream consumer of type " + consumer.getClass().getCanonicalName());
            }
            ArrayList threads = Lists.newArrayList();
            if (bytesSubscription.isEmpty() && lineSubscriptions.isEmpty()) {
                threads.add(new Blackhole(is));
            } else if (bytesSubscription.isEmpty()) {
                threads.add(new StreamToLine(threadBaseName, is, lineSubscriptions));
            } else if (!lineSubscriptions.isEmpty()) {
                PipedOutputStream pos = new PipedOutputStream();
                PipedInputStream pis = new PipedInputStream(pos);
                bytesSubscription.add(new OutputStreamSubscription(pos, true));
                threads.add(new StreamDuplicator(is, bytesSubscription));
                threads.add(new StreamToLine(threadBaseName, pis, lineSubscriptions));
            } else {
                threads.add(new StreamDuplicator(is, bytesSubscription));
            }
            return threads;
        }
    }

    public static interface LazyInitExecKiller {
        public void kill();

        public void setWaitingThread(ExecWaitingThead var1);
    }

    public static interface ExecCompletionHandler {
        public void init(ExecBuilder var1);

        public void handle(int var1) throws IOException;
    }

    public static interface ExecCleanuper {
        public void cleanup();
    }

    public static interface LineSubscription
    extends ExecSubscription {
        public void handle(String var1, boolean var2) throws IOException;
    }

    public static interface BytesSubscription
    extends ExecSubscription {
        public void handle(byte[] var1, int var2) throws IOException;
    }

    public static interface ExecSubscription {
        public void close() throws IOException;
    }

    private static class ExecWaitingThead
    extends Thread {
        private int rv;
        private final Process p;

        private ExecWaitingThead(Process p) {
            this.p = p;
        }

        @Override
        public void run() {
            try {
                this.rv = this.p.waitFor();
                LOGGER.info("Done waiting for return value,  got " + this.rv, new Object[0]);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("Exec wait interrupted", e);
            }
        }

        public boolean isRunning() {
            return this.isAlive();
        }

        public int waitFor() throws InterruptedException {
            this.join();
            return this.rv;
        }

        public int waitFor(long timeout) throws InterruptedException {
            this.join(timeout);
            return this.rv;
        }

        public void niceKill() {
            int pid = ProcessUtil.getPid(this.p);
            try {
                Runtime.getRuntime().exec("kill -SIGINT " + pid);
            }
            catch (IOException e) {
                LOGGER.error("Nice kill failed (pid=" + pid + ")", e);
            }
        }

        public void evilKill() {
            int pid = ProcessUtil.getPid(this.p);
            try {
                this.p.destroy();
                Runtime.getRuntime().exec("kill -SIGKILL " + pid);
            }
            catch (IOException e) {
                LOGGER.error("Evil kill failed (pid=" + pid + ")", e);
            }
        }
    }

    public static class ExecBuilder {
        private String threadsBaseName;
        private List<ExecSubscription> outputConsumers = Lists.newArrayList();
        private List<ExecSubscription> errorConsumers = Lists.newArrayList();
        private List<ExecCleanuper> cleanupers = Lists.newArrayList();
        private ProcessBuilder pb;
        private String[] args;
        private Map<String, String> env;
        private File cwd;
        private String input;
        private ExecCompletionHandler completionHandler;
        private LazyInitExecKiller killer;

        public ExecBuilder withThreadsBaseName(String threadsBaseName) {
            this.threadsBaseName = threadsBaseName;
            return this;
        }

        public ExecBuilder withCompletionHandler(ExecCompletionHandler completionHandler) {
            this.completionHandler = completionHandler;
            completionHandler.init(this);
            return this;
        }

        public ExecBuilder withOutputConsumer(ExecSubscription consumer) {
            this.outputConsumers.add(consumer);
            return this;
        }

        public ExecBuilder withErrorConsumer(ExecSubscription consumer) {
            this.errorConsumers.add(consumer);
            return this;
        }

        public ExecBuilder withOutputConsumers(List<ExecSubscription> consumers) {
            this.outputConsumers.addAll(consumers);
            return this;
        }

        public ExecBuilder withErrorConsumers(List<ExecSubscription> consumers) {
            this.errorConsumers.addAll(consumers);
            return this;
        }

        public ExecBuilder withCleanuper(ExecCleanuper cleanuper) {
            this.cleanupers.add(cleanuper);
            return this;
        }

        public ExecBuilder withCleanupers(List<ExecCleanuper> cleanupers) {
            this.cleanupers.addAll(cleanupers);
            return this;
        }

        public ExecBuilder withProcessBuilder(ProcessBuilder pb) {
            if (this.args != null) {
                throw new IllegalArgumentException("Cannot set process builder after args");
            }
            this.pb = pb;
            return this;
        }

        public ExecBuilder withArgs(List<String> args) {
            return this.withArgs(args.toArray(new String[0]));
        }

        public ExecBuilder withArgs(String[] args) {
            if (this.pb != null) {
                throw new IllegalArgumentException("Cannot set args after process builder");
            }
            this.args = args;
            return this;
        }

        public ExecBuilder withEnv(Map<String, String> env) {
            if (this.env == null) {
                this.env = env;
            } else {
                this.env.putAll(env);
            }
            return this;
        }

        public ExecBuilder withEnv(String key, String value) {
            if (this.env == null) {
                this.env = Maps.newHashMap();
            }
            this.env.put(key, value);
            return this;
        }

        public ExecBuilder withCwd(File cwd) {
            this.cwd = cwd;
            return this;
        }

        public ExecBuilder withInput(String input) {
            this.input = input;
            return this;
        }

        public ExecBuilder withKiller(LazyInitExecKiller killer) {
            this.killer = killer;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int exec() throws IOException, InterruptedException {
            if (this.args != null) {
                this.pb = new ProcessBuilder(this.args);
            }
            if (this.env != null) {
                this.pb.environment().putAll(this.env);
            }
            if (this.cwd != null) {
                this.pb = this.pb.directory(this.cwd);
            }
            Process p = this.pb.start();
            ExecOutputConsumer consumer = new ExecOutputConsumer().withInput(this.input).withOutputConsumers(this.outputConsumers).withErrorConsumers(this.errorConsumers).withThreadsBaseName(this.threadsBaseName);
            consumer.start(p.getInputStream(), p.getErrorStream(), p.getOutputStream());
            ExecWaitingThead waitingThread = new ExecWaitingThead(p);
            waitingThread.start();
            if (this.killer != null) {
                this.killer.setWaitingThread(waitingThread);
            }
            try {
                int returnCode = waitingThread.waitFor();
                if (this.completionHandler != null) {
                    this.completionHandler.handle(returnCode);
                }
                int n = returnCode;
                return n;
            }
            finally {
                consumer.finish();
                for (ExecCleanuper cleanuper : this.cleanupers) {
                    cleanuper.cleanup();
                }
            }
        }
    }
}

