/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.process;

import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ProcessUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalProcess {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(ExternalProcess.class);
    private final ProcessBuilder def;
    private final File runDir;
    private final Thread waitingThread;
    private final User user;
    private Process p;
    private int pid = 0;
    private int returnCode = -1;

    public ExternalProcess(ProcessBuilder def, File runDir, User user) {
        this.def = def;
        this.runDir = runDir;
        this.user = user;
        this.waitingThread = new Thread(() -> {
            try {
                Thread.currentThread().setName("RegularExec-" + Thread.currentThread().getId());
                this.returnCode = this.p.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("Unexpected interruption!", e);
            }
        });
    }

    public void start() throws IOException {
        this.def.directory(this.runDir);
        LOGGER.info("Starting process (regular)", new Object[0]);
        this.p = this.def.start();
        this.pid = ProcessUtil.getPid(this.p);
        LOGGER.info("Process started with pid=" + this.pid, new Object[0]);
        this.waitingThread.start();
    }

    public int getWorkingPid() {
        return this.pid;
    }

    public void niceKill() {
        int pid = ProcessUtil.getPid(this.p);
        try {
            Runtime.getRuntime().exec("kill -SIGINT " + pid);
        }
        catch (IOException e) {
            LOGGER.error("Nice kill failed (pid=" + pid + ")", e);
        }
    }

    public void evilKill() {
        int pid = ProcessUtil.getPid(this.p);
        LOGGER.info(String.format("Killing process PID: %d", pid), new Object[0]);
        try {
            this.p.destroy();
            Runtime.getRuntime().exec("kill -SIGKILL " + pid);
        }
        catch (IOException e) {
            LOGGER.error("Evil kill failed (pid=" + pid + ")", e);
        }
    }

    public void niceThenEvilKill() {
        if (this.isRunning()) {
            LOGGER.info("Process is still running, sending SIGINT...", new Object[0]);
            this.niceKill();
            try {
                this.waitFor(15000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("Unexpected interruption", e);
            }
            if (this.isRunning()) {
                LOGGER.info("Process is still running after 15000ms, sending SIGKILL...", new Object[0]);
                this.evilKill();
                try {
                    this.waitFor(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.error("Unexpected interruption", e);
                }
                if (this.isRunning()) {
                    LOGGER.info("Process is still alive after SIGINT and SIGKILL. Too strong for us...", new Object[0]);
                } else {
                    LOGGER.info("Process has been abruptly killed. Cleanup may be incomplete.", new Object[0]);
                }
            } else {
                LOGGER.info("Process has been nicely interrupted!", new Object[0]);
            }
        }
    }

    public boolean isRunning() {
        return this.waitingThread.isAlive();
    }

    private int waitFor(long timeout) throws InterruptedException {
        this.waitingThread.join(timeout);
        return this.returnCode;
    }

    public int waitFor() throws InterruptedException {
        this.waitingThread.join();
        return this.returnCode;
    }

    public OutputStream getOutputStream() {
        return this.p.getOutputStream();
    }

    public InputStream getInputStream() {
        return this.p.getInputStream();
    }

    public InputStream getErrorStream() {
        return this.p.getErrorStream();
    }
}

