/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.process;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.config.Configurable;
import com.mware.core.config.Configuration;
import com.mware.core.lifecycle.LifeSupportService;
import com.mware.core.lifecycle.LifecycleAdapter;
import com.mware.core.model.longRunningProcess.LongRunningProcessRunner;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.StoppableRunnable;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class LongRunningProcessRunnerProcess
extends LifecycleAdapter {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(LongRunningProcessRunnerProcess.class);
    private final Configuration configuration;
    private final Config config;
    private final List<StoppableRunnable> stoppables = new ArrayList<StoppableRunnable>();

    @Inject
    public LongRunningProcessRunnerProcess(Configuration configuration, LifeSupportService lifeSupportService) {
        this.configuration = configuration;
        this.config = configuration.setConfigurables(new Config(), LongRunningProcessRunnerProcess.class.getName());
        lifeSupportService.add(this);
    }

    @Override
    public void start() {
        if (this.config.threadCount <= 0) {
            LOGGER.info("'threadCount' not configured or was 0", new Object[0]);
            return;
        }
        this.stoppables.addAll(LongRunningProcessRunner.startThreaded(this.config.threadCount, this.configuration));
    }

    @Override
    public void shutdown() {
        this.stoppables.forEach(StoppableRunnable::stop);
    }

    public static class Config {
        @Configurable
        public int threadCount;
    }
}

