/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.process;

import java.io.IOException;

public class ProcessDiedException
extends IOException {
    public ProcessDiedException(String message) {
        super(message);
    }

    public ProcessDiedException(String message, Throwable cause) {
        super(message, cause);
    }

    public static ProcessDiedException getExceptionOnProcessDeath(String description, Throwable origException, boolean manuallyAborted, Integer processReturnCode) {
        if (processReturnCode != null) {
            if (manuallyAborted) {
                return new ProcessDiedException(description + " - manually aborted");
            }
            if (processReturnCode == 137) {
                return new ProcessDiedException(description + " (exit code: " + processReturnCode + ", killed - maybe out of memory ?)");
            }
            if (processReturnCode == 0) {
                return new ProcessDiedException(description + " - without error code");
            }
            return new ProcessDiedException(description + " (exit code: " + processReturnCode + ")");
        }
        if (origException != null) {
            return new ProcessDiedException(description + " seems to have died", origException);
        }
        return new ProcessDiedException(description + " seems to have died", origException);
    }
}

