/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.security;

import com.mware.core.security.AuthTokenException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class AuthToken {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final String userId;
    private final SecretKey jwtKey;
    private final Date expiration;
    private final String tokenId;

    public AuthToken(String userId, SecretKey macKey, Date expiration) {
        this(AuthToken.generateTokenId(), userId, macKey, expiration);
    }

    private AuthToken(String tokenId, String userId, SecretKey macKey, Date expiration) {
        this.tokenId = tokenId;
        this.userId = userId;
        this.jwtKey = macKey;
        this.expiration = expiration;
    }

    public static SecretKey generateKey(String keyPassword, String keySalt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(keyPassword.toCharArray(), keySalt.getBytes(), 10000, 256);
        return factory.generateSecret(spec);
    }

    public static AuthToken parse(String token, SecretKey macKey) throws AuthTokenException {
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            MACVerifier verifier = new MACVerifier(macKey);
            if (signedJWT.verify((JWSVerifier)verifier)) {
                JWTClaimsSet claims = signedJWT.getJWTClaimsSet();
                return new AuthToken(claims.getJWTID(), claims.getSubject(), macKey, claims.getExpirationTime());
            }
            throw new AuthTokenException("JWT signature verification failed");
        }
        catch (Exception e) {
            throw new AuthTokenException(e);
        }
    }

    public String serialize() throws AuthTokenException {
        JWTClaimsSet claims = new JWTClaimsSet.Builder().jwtID(this.tokenId).subject(this.userId).expirationTime(this.expiration).build();
        try {
            SignedJWT signedJwt = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claims);
            MACSigner signer = new MACSigner(this.jwtKey);
            signedJwt.sign((JWSSigner)signer);
            return signedJwt.serialize();
        }
        catch (Exception e) {
            throw new AuthTokenException(e);
        }
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public boolean isExpired(int toleranceInSeconds) {
        Calendar expirationWithTolerance = Calendar.getInstance();
        expirationWithTolerance.setTime(this.expiration);
        expirationWithTolerance.add(13, toleranceInSeconds);
        return expirationWithTolerance.getTime().before(new Date());
    }

    private static String generateTokenId() {
        byte[] randomBytes = new byte[128];
        SECURE_RANDOM.nextBytes(randomBytes);
        ByteBuffer currentTimeBuffer = ByteBuffer.allocate(8);
        currentTimeBuffer.putLong(System.currentTimeMillis());
        return Base64.getEncoder().encodeToString(randomBytes) + "@" + Base64.getEncoder().encodeToString(currentTimeBuffer.array());
    }
}

