/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.security;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.model.user.UserRepository;
import com.mware.core.security.AuthToken;
import com.mware.core.security.AuthTokenException;
import com.mware.core.user.User;
import javax.crypto.SecretKey;

@Singleton
public class AuthTokenService {
    private SecretKey tokenSigningKey;
    private int tokenExpirationToleranceInSeconds;
    private UserRepository userRepository;

    @Inject
    public AuthTokenService(Configuration configuration, UserRepository userRepository) {
        String keyPassword = configuration.get("auth.token.password", "4X5rWTCDKbbFoUy7TrxoaKTKQkBgnUB8d45jvABwHgo");
        Preconditions.checkNotNull((Object)keyPassword, (Object)"AtmosphereConfig init parameter 'auth.token.password' was not set.");
        String keySalt = configuration.get("auth.token.salt", "jNQheYMYfNY8sLc61LuGEg");
        Preconditions.checkNotNull((Object)keySalt, (Object)"AtmosphereConfig init parameter 'auth.token.salt' was not set.");
        this.tokenExpirationToleranceInSeconds = configuration.getInt("auth.token.expiration_tolerance_seconds", 0);
        this.userRepository = userRepository;
        try {
            this.tokenSigningKey = AuthToken.generateKey(keyPassword, keySalt);
        }
        catch (Exception e) {
            throw new BcException("Key generation failed", e);
        }
    }

    public User validateToken(String authToken) throws AuthTokenException {
        AuthToken token = AuthToken.parse(authToken, this.tokenSigningKey);
        if (token != null && !token.isExpired(this.tokenExpirationToleranceInSeconds)) {
            return this.userRepository.findById(token.getUserId());
        }
        return null;
    }
}

