/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.security;

import com.mware.ge.Visibility;
import org.apache.commons.lang.StringUtils;

public class BcVisibility {
    public static final String SUPER_USER_VISIBILITY_STRING = "administrator";
    private final Visibility visibility;

    public BcVisibility() {
        this.visibility = new Visibility("");
    }

    public BcVisibility(String visibility) {
        this.visibility = visibility == null || visibility.length() == 0 ? new Visibility("") : this.addSuperUser(visibility);
    }

    public BcVisibility(Visibility visibility) {
        this.visibility = visibility == null || visibility.getVisibilityString().length() == 0 || visibility.getVisibilityString().contains(SUPER_USER_VISIBILITY_STRING) ? visibility : this.addSuperUser(visibility.getVisibilityString());
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    private Visibility addSuperUser(String visibility) {
        return new Visibility("(" + visibility + ")|" + SUPER_USER_VISIBILITY_STRING);
    }

    public Visibility orVisibility(String visibility) {
        if (StringUtils.isEmpty((String)this.visibility.getVisibilityString())) {
            return new Visibility("(" + visibility + ")");
        }
        return new Visibility(this.visibility.getVisibilityString() + "|" + visibility);
    }

    public String toString() {
        return this.getVisibility().toString();
    }

    public static Visibility and(Visibility visibility, String additionalVisibility) {
        if (visibility.getVisibilityString().length() == 0) {
            return new Visibility(additionalVisibility);
        }
        return new Visibility("(" + visibility.getVisibilityString() + ")&(" + additionalVisibility + ")");
    }

    public static Visibility or(Visibility visibility, String additionalVisibility) {
        if (visibility.getVisibilityString().length() == 0) {
            return new Visibility(additionalVisibility);
        }
        return new Visibility("(" + visibility.getVisibilityString() + ")|(" + additionalVisibility + ")");
    }
}

