/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.security;

import com.google.inject.Inject;
import com.mware.core.model.user.UserRepository;
import com.mware.core.security.AuditEventType;
import com.mware.core.security.AuditService;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.Graph;
import com.mware.ge.Visibility;
import com.mware.ge.time.Clocks;
import com.mware.ge.util.Preconditions;
import com.mware.ge.values.storable.LocalDateTimeValue;
import com.mware.ge.values.storable.Values;
import java.util.Objects;
import java.util.UUID;

public class ExtendedDataAuditService
implements AuditService {
    private final Graph graph;
    private final UserRepository userRepository;
    private static final String AUDIT_VERTEX_ID = "audit_vertex";
    private static final String AUDIT_TABLE = "audit_table";
    private static final String AUDIT_WORKSPACE_ID_COLUMN = "workspace_id";
    private static final String AUDIT_USERID_COLUMN = "user_id";
    private static final String AUDIT_USERNAME_COLUMN = "user_name";
    private static final String AUDIT_DATETIME_COLUMN = "time";
    private static final String AUDIT_EVENT_TYPE_COLUMN = "event_type";
    private static final String AUDIT_EVENT_KEY_COLUMN = "event_key";
    private static final String AUDIT_EVENT_VALUE_COLUMN = "event_value";
    private static final Authorizations AUTHORIZATIONS_ALL = new Authorizations("administrator");
    private static final Visibility VISIBILITY_PUBLIC = new Visibility("administrator");

    @Inject
    public ExtendedDataAuditService(Graph graph, UserRepository userRepository) {
        this.graph = graph;
        this.userRepository = userRepository;
        this.ensureAuditVertexExists();
    }

    private void ensureAuditVertexExists() {
        if (!this.graph.doesVertexExist(AUDIT_VERTEX_ID, AUTHORIZATIONS_ALL)) {
            this.graph.prepareVertex(AUDIT_VERTEX_ID, VISIBILITY_PUBLIC, "thing").save(AUTHORIZATIONS_ALL);
            this.graph.flush();
        }
    }

    @Override
    public void auditLogin(User user) {
        this.createAuditRow("", user.getUserId(), user.getUsername(), AuditEventType.LOGIN, "", "");
    }

    @Override
    public void auditLogout(String userId) {
        User user = this.userRepository.findById(userId);
        this.createAuditRow("", userId, user.getUsername(), AuditEventType.LOGOUT, "", "");
    }

    @Override
    public void auditAccessDenied(String message, User user, Object resourceId) {
        this.createAuditRow("", user.getUserId(), user.getUsername(), AuditEventType.ACCESS_DENIED, Objects.toString(resourceId), message);
    }

    @Override
    public void auditGenericEvent(User user, String workspaceId, AuditEventType type, String key, String value) {
        this.createAuditRow(workspaceId, user.getUserId(), user.getUsername(), type, key, value);
    }

    private void createAuditRow(String workspaceId, String userId, String userName, AuditEventType type, String key, String value) {
        Preconditions.checkNotNull(type);
        String rowId = UUID.randomUUID().toString();
        this.graph.getVertex(AUDIT_VERTEX_ID, AUTHORIZATIONS_ALL).prepareMutation().addExtendedData(AUDIT_TABLE, rowId, AUDIT_WORKSPACE_ID_COLUMN, Values.stringValue(workspaceId), VISIBILITY_PUBLIC).addExtendedData(AUDIT_TABLE, rowId, AUDIT_USERID_COLUMN, Values.stringValue(userId), VISIBILITY_PUBLIC).addExtendedData(AUDIT_TABLE, rowId, AUDIT_USERNAME_COLUMN, Values.stringValue(userName), VISIBILITY_PUBLIC).addExtendedData(AUDIT_TABLE, rowId, AUDIT_DATETIME_COLUMN, LocalDateTimeValue.now(Clocks.systemClock()), VISIBILITY_PUBLIC).addExtendedData(AUDIT_TABLE, rowId, AUDIT_EVENT_TYPE_COLUMN, Values.stringValue(type.name()), VISIBILITY_PUBLIC).addExtendedData(AUDIT_TABLE, rowId, AUDIT_EVENT_KEY_COLUMN, Values.stringValue(key), VISIBILITY_PUBLIC).addExtendedData(AUDIT_TABLE, rowId, AUDIT_EVENT_VALUE_COLUMN, Values.stringValue(value), VISIBILITY_PUBLIC).save(AUTHORIZATIONS_ALL);
        this.graph.flush();
    }
}

