/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.security;

import com.google.inject.Singleton;
import com.mware.core.security.AuditEventType;
import com.mware.core.security.AuditService;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;

@Singleton
public class LoggingAuditService
implements AuditService {
    private static final BcLogger AUDIT_LOGGER = BcLoggerFactory.getLogger("com.mware.audit.AuditService");

    @Override
    public void auditLogin(User user) {
        if (AUDIT_LOGGER.isInfoEnabled()) {
            AUDIT_LOGGER.info("Login \"%s\" (username: %s)", user.getUserId(), user.getUsername());
        }
    }

    @Override
    public void auditLogout(String userId) {
        if (AUDIT_LOGGER.isInfoEnabled()) {
            AUDIT_LOGGER.info("Logout \"%s\"", userId);
        }
    }

    @Override
    public void auditAccessDenied(String message, User user, Object resourceId) {
        AUDIT_LOGGER.warn("Access denied \"%s\" (userId: %s, resourceId: %s)", message, user == null ? "unknown" : user.getUserId(), resourceId);
    }

    @Override
    public void auditGenericEvent(User user, String workspaceId, AuditEventType type, String key, String value) {
        if (AUDIT_LOGGER.isInfoEnabled()) {
            AUDIT_LOGGER.info("Event \"%s\" on user with username \"%s\" (workspace \"%s\") :: \"%s:%s\"", type.name(), user.getUsername(), workspaceId, key, value);
        }
    }
}

