/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.status;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;

public class PausableTimerContext {
    private final Timer timer;
    private final Clock clock;
    private long startTime;
    private long totalTime;
    private boolean paused;

    public PausableTimerContext(Timer timer) {
        this.timer = timer;
        this.clock = Clock.defaultClock();
        this.startTime = this.clock.getTick();
        this.totalTime = 0L;
        this.paused = false;
    }

    public long stop() {
        this.pause();
        this.timer.update(this.totalTime, TimeUnit.NANOSECONDS);
        return this.totalTime;
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        this.totalTime += this.clock.getTick() - this.startTime;
        this.paused = true;
    }

    public void resume() {
        this.startTime = this.clock.getTick();
        this.paused = false;
    }
}

