/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.status;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.clientapi.util.IOUtils;
import com.mware.core.status.StatusData;
import com.mware.core.status.StatusRepository;
import com.mware.core.status.model.ProcessStatus;
import com.mware.core.status.model.Status;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ClientApiConverter;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.json.JSONObject;

public abstract class StatusServer {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(StatusServer.class);
    private final Configuration configuration;
    private final HttpServer httpServer;
    private final Date startTime;
    private final String type;
    private final Class sourceClass;
    private final StatusRepository.StatusHandle statusHandle;
    private final StatusRepository statusRepository;
    private final Template hbsTemplate;

    public StatusServer(Configuration configuration, StatusRepository statusRepository, String type, Class sourceClass) {
        this.statusRepository = statusRepository;
        this.sourceClass = sourceClass;
        this.type = type;
        this.configuration = configuration;
        this.startTime = new Date();
        String portRange = configuration.get("status.portRange", "40000-41000");
        this.httpServer = this.startHttpServer(portRange);
        String url = this.getUrl();
        LOGGER.debug("Using url: " + url, new Object[0]);
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            String hostAddress = InetAddress.getLocalHost().getHostAddress();
            StatusData statusData = new StatusData(url, hostname, hostAddress);
            this.statusHandle = statusRepository.saveStatus(type, UUID.randomUUID().toString(), statusData);
        }
        catch (UnknownHostException e) {
            throw new BcException("Could not get local host address", e);
        }
        try {
            Handlebars handlebars = new Handlebars();
            ByteArrayOutputStream templateStream = new ByteArrayOutputStream();
            IOUtils.copy(StatusServer.class.getResourceAsStream("status.hbs"), templateStream);
            this.hbsTemplate = handlebars.compileInline(templateStream.toString("UTF-8"));
        }
        catch (Exception ex) {
            throw new BcException("Could not load StatusServer hbs template");
        }
    }

    private String getUrl() {
        try {
            String hostname = InetAddress.getLocalHost().getHostAddress();
            return String.format("http://%s:%d/", hostname, this.httpServer.getAddress().getPort());
        }
        catch (UnknownHostException ex) {
            throw new BcException("Could not create url", ex);
        }
    }

    private HttpServer startHttpServer(String portRange) {
        String[] parts = portRange.split("-");
        if (parts.length != 2) {
            throw new BcException("Invalid port range: " + portRange);
        }
        int startPort = Integer.parseInt(parts[0]);
        int endPort = Integer.parseInt(parts[1]);
        return this.startHttpServer(startPort, endPort);
    }

    private HttpServer startHttpServer(int startPort, int endPort) {
        for (int i = startPort; i < endPort; ++i) {
            try {
                HttpServer httpServer = HttpServer.create(new InetSocketAddress(i), 0);
                httpServer.createContext("/", new StatusHandler());
                httpServer.setExecutor(null);
                httpServer.start();
                LOGGER.info("Started status HTTP server on port: %s", i);
                return httpServer;
            }
            catch (BindException ex) {
                LOGGER.debug("Could not start HTTP server on port %d", i);
                continue;
            }
            catch (Throwable ex) {
                LOGGER.debug("Could not start HTTP server on port %d", i, ex);
            }
        }
        throw new BcException("Could not start HTTP status server");
    }

    public void shutdown() {
        try {
            this.httpServer.stop(0);
        }
        catch (Throwable ex) {
            LOGGER.error("Could not stop http server", ex);
        }
        this.statusRepository.deleteStatus(this.statusHandle);
    }

    private Status getStatus() {
        ProcessStatus status = this.createStatus();
        StatusServer.getGeneralInfo(status, this.sourceClass);
        status.setType(this.type);
        status.setStartTime(this.startTime);
        try {
            status.setHostname(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            LOGGER.error("Could not get hostname", new Object[0]);
        }
        status.setOsUser(System.getProperty("user.name"));
        for (Map.Entry<String, String> envEntry : System.getenv().entrySet()) {
            status.getEnv().put(envEntry.getKey(), envEntry.getValue());
        }
        status.setConfiguration(ClientApiConverter.toClientApiValue(this.getConfigurationJson()));
        status.getJvm().setClasspath(System.getProperty("java.class.path"));
        return status;
    }

    protected abstract ProcessStatus createStatus();

    private JSONObject getConfigurationJson() {
        JSONObject json = new JSONObject();
        json.put("properties", (Object)this.configuration.getJsonProperties());
        json.put("configurationInfo", (Object)this.configuration.getConfigurationInfo());
        return json;
    }

    private static Manifest getManifest(Class clazz) {
        try {
            String className = clazz.getSimpleName() + ".class";
            URL resource = clazz.getResource(className);
            if (resource == null) {
                LOGGER.error("Could not get class manifest: " + clazz.getName() + ", could not find resource: " + className, new Object[0]);
                return null;
            }
            String classPath = resource.toString();
            if (!classPath.startsWith("jar")) {
                return null;
            }
            String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            return new Manifest(new URL(manifestPath).openStream());
        }
        catch (Exception ex) {
            LOGGER.error("Could not get class manifest: " + clazz.getName(), ex);
            return null;
        }
    }

    public static void getGeneralInfo(JSONObject json, Class clazz) {
        Manifest manifest;
        Description descriptionAnnotation;
        json.put("className", (Object)clazz.getName());
        Name nameAnnotation = clazz.getAnnotation(Name.class);
        if (nameAnnotation != null) {
            json.put("name", (Object)nameAnnotation.value());
        }
        if ((descriptionAnnotation = clazz.getAnnotation(Description.class)) != null) {
            json.put("description", (Object)descriptionAnnotation.value());
        }
        if ((manifest = StatusServer.getManifest(clazz)) != null) {
            Attributes mainAttributes = manifest.getMainAttributes();
            json.put("projectVersion", (Object)mainAttributes.getValue("Project-Version"));
            json.put("gitRevision", (Object)mainAttributes.getValue("Git-Revision"));
            json.put("builtBy", (Object)mainAttributes.getValue("Built-By"));
            String value = mainAttributes.getValue("Built-On-Unix");
            if (value != null) {
                json.put("builtOn", Long.parseLong(value));
            }
        }
    }

    public static void getGeneralInfo(Status generalStatus, Class clazz) {
        Manifest manifest;
        Description descriptionAnnotation;
        generalStatus.setClassName(clazz.getName());
        Name nameAnnotation = clazz.getAnnotation(Name.class);
        if (nameAnnotation != null) {
            generalStatus.setName(nameAnnotation.value());
        }
        if ((descriptionAnnotation = clazz.getAnnotation(Description.class)) != null) {
            generalStatus.setDescription(descriptionAnnotation.value());
        }
        if ((manifest = StatusServer.getManifest(clazz)) != null) {
            Attributes mainAttributes = manifest.getMainAttributes();
            generalStatus.setProjectVersion(mainAttributes.getValue("Project-Version"));
            generalStatus.setGitRevision(mainAttributes.getValue("Git-Revision"));
            generalStatus.setBuiltBy(mainAttributes.getValue("Built-By"));
            String value = mainAttributes.getValue("Built-On-Unix");
            if (value != null) {
                generalStatus.setBuiltOn(new Date(Long.parseLong(value)));
            }
        }
    }

    private class StatusHandler
    implements HttpHandler {
        private StatusHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            try {
                Status status = StatusServer.this.getStatus();
                String responseString = StatusServer.this.hbsTemplate.apply((Object)status);
                Headers responseHeaders = t.getResponseHeaders();
                responseHeaders.set("Content-Type", "text/html");
                t.sendResponseHeaders(200, 0L);
                OutputStream os = t.getResponseBody();
                os.write(responseString.getBytes());
                os.close();
            }
            catch (Throwable ex) {
                LOGGER.error("Could not process request", ex);
            }
        }
    }
}

