/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.trace;

import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.exception.BcException;
import com.mware.core.trace.DefaultTraceRepository;
import com.mware.core.trace.TraceRepository;
import com.mware.core.trace.TraceSpan;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import java.util.HashMap;
import java.util.Map;

public class Trace {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(Trace.class);
    private static TraceRepository traceRepository;

    public static void on(String description) {
        Trace.getTraceRepository().on(description, new HashMap<String, String>());
    }

    public static TraceSpan on(String description, Map<String, String> data) {
        return Trace.getTraceRepository().on(description, data);
    }

    public static void off() {
        Trace.getTraceRepository().off();
    }

    public static TraceSpan start(String description) {
        return Trace.getTraceRepository().start(description);
    }

    public static boolean isEnabled() {
        return Trace.getTraceRepository().isEnabled();
    }

    private static TraceRepository getTraceRepository() {
        if (traceRepository == null) {
            try {
                traceRepository = InjectHelper.getInstance(TraceRepository.class);
            }
            catch (BcException e) {
                LOGGER.warn("TraceRepository not found through injection. Using no-op DefaultTraceRepository", new Object[0]);
                traceRepository = new DefaultTraceRepository();
            }
        }
        return traceRepository;
    }
}

