/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.trace;

import com.mware.core.trace.Trace;
import com.mware.core.trace.TraceSpan;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TracedMethodInterceptor
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (Trace.isEnabled()) {
            String description = invocation.getMethod().getDeclaringClass().getSimpleName() + "." + invocation.getMethod().getName();
            try (TraceSpan trace = Trace.start(description);){
                Object[] invocationArguments = invocation.getArguments();
                for (int i = 0; i < invocationArguments.length; ++i) {
                    String argumentName = "arg" + i;
                    this.addArgumentToData(trace, argumentName, invocationArguments[i]);
                }
                Object object = invocation.proceed();
                return object;
            }
        }
        return invocation.proceed();
    }

    private void addArgumentToData(TraceSpan trace, String argumentName, Object invocationArgument) {
        String value = invocationArgument == null ? "(null)" : invocationArgument.toString();
        trace.data(argumentName, value);
    }
}

