/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import org.slf4j.Logger;

public class BcLogger {
    private final Logger logger;

    public BcLogger(Logger logger) {
        this.logger = logger;
    }

    public void trace(String format, Object ... args) {
        if (this.isDebugEnabled()) {
            this.logger.trace(this.format(format, args), this.findLastThrowable(args));
        }
    }

    public void trace(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.logger.trace(message, t);
        }
    }

    public void debug(String format, Object ... args) {
        if (this.isDebugEnabled()) {
            this.logger.debug(this.format(format, args), this.findLastThrowable(args));
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.logger.debug(message, t);
        }
    }

    public void info(String format, Object ... args) {
        if (this.isInfoEnabled()) {
            this.logger.info(this.format(format, args), this.findLastThrowable(args));
        }
    }

    public void info(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.logger.info(message, t);
        }
    }

    public void warn(String format, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.format(format, args), this.findLastThrowable(args));
        }
    }

    public void warn(String message, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message, t);
        }
    }

    public void error(String format, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.format(format, args), this.findLastThrowable(args));
        }
    }

    public void error(String message, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message, t);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    private String format(String format, Object[] args) {
        try {
            if (args.length == 0) {
                return format;
            }
            return String.format(format, args);
        }
        catch (Exception ex) {
            this.error("Invalid format string: " + format, ex);
            StringBuilder sb = new StringBuilder();
            sb.append(format);
            for (Object arg : args) {
                sb.append(", ");
                sb.append(arg);
            }
            return sb.toString();
        }
    }

    private Throwable findLastThrowable(Object[] args) {
        int length = args != null ? args.length : 0;
        return length > 0 && args[length - 1] instanceof Throwable ? (Throwable)args[length - 1] : null;
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }
}

