/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mware.core.config.ConfigurationLoader;
import com.mware.core.util.BcLogger;
import com.mware.core.util.ProcessUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class BcLoggerFactory {
    private static final Map<String, BcLogger> logMap = new HashMap<String, BcLogger>();
    private static boolean initialized = false;
    private static boolean initializing = false;

    public static BcLogger getLogger(Class clazz, String processType) {
        if (processType != null) {
            BcLoggerFactory.setProcessType(processType);
        } else {
            BcLoggerFactory.setProcessType(clazz.getSimpleName());
        }
        BcLoggerFactory.ensureInitialized();
        return BcLoggerFactory.getLogger(clazz.getName());
    }

    public static BcLogger getLogger(Class clazz) {
        return BcLoggerFactory.getLogger(clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureInitialized() {
        Map<String, BcLogger> map = logMap;
        synchronized (map) {
            if (!initialized && !initializing) {
                initializing = true;
                if (System.getProperty("logFileSuffix") == null) {
                    String hostname = null;
                    try {
                        hostname = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        System.err.println("Could not get host name: " + e.getMessage());
                    }
                    String logFileSuffix = "-" + Joiner.on((String)"-").skipNulls().join((Object)BcLoggerFactory.getProcessType(), (Object)hostname, new Object[]{ProcessUtil.getPid()});
                    System.setProperty("logFileSuffix", logFileSuffix);
                }
                ConfigurationLoader.configureLog4j();
                initialized = true;
                initializing = false;
                BcLoggerFactory.logSystem();
            }
        }
    }

    private static void logSystem() {
        BcLogger logger = BcLoggerFactory.getLogger(BcLoggerFactory.class);
        if (logger.isDebugEnabled()) {
            BcLoggerFactory.logEnv(logger);
            BcLoggerFactory.logSystemProperties(logger);
            BcLoggerFactory.logJvmInputArguments(logger);
        }
    }

    private static void logJvmInputArguments(BcLogger logger) {
        logger.info("jvm input arguments:", new Object[0]);
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        for (String arg : arguments) {
            logger.info("  %s", arg);
        }
    }

    private static void logSystemProperties(BcLogger logger) {
        logger.info("system properties:", new Object[0]);
        ArrayList properties = Lists.newArrayList(System.getProperties().entrySet());
        Collections.sort(properties, new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> o1, Map.Entry<Object, Object> o2) {
                return o1.getKey().toString().compareTo(o2.getKey().toString());
            }
        });
        for (Map.Entry entry : properties) {
            logger.info("  %s: %s", entry.getKey(), entry.getValue());
        }
    }

    private static void logEnv(BcLogger logger) {
        logger.info("environment:", new Object[0]);
        ArrayList entries = Lists.newArrayList(System.getenv().entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : entries) {
            logger.info("  %s: %s", entry.getKey(), entry.getValue());
        }
    }

    public static void setProcessType(String processType) {
        if (BcLoggerFactory.getProcessType() == null) {
            if (initializing) {
                System.err.println("setProcessType called too late");
            } else if (initialized) {
                BcLoggerFactory.getLogger(BcLoggerFactory.class).warn("setProcessType called too late", new Object[0]);
            }
            System.setProperty("bc.processType", processType);
        }
    }

    private static String getProcessType() {
        return System.getProperty("bc.processType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BcLogger getLogger(String name) {
        BcLoggerFactory.ensureInitialized();
        Map<String, BcLogger> map = logMap;
        synchronized (map) {
            BcLogger logger = logMap.get(name);
            if (logger != null) {
                return logger;
            }
            logger = new BcLogger(LoggerFactory.getLogger((String)name));
            logMap.put(name, logger);
            return logger;
        }
    }
}

