/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import com.mware.core.exception.BcException;
import com.mware.core.util.BcLogger;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class ClassUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static <T> Class<? extends T> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new BcException("Could not load class " + className, e);
        }
    }

    public static Method findMethod(Class clazz, String methodName, Class[] parameters) {
        while (clazz != null) {
            try {
                return ClassUtil.getDeclaredMethod(clazz, methodName, parameters);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static void logClasspath(ClassLoader classLoader) {
        ClassUtil.logClasspath(classLoader, System.out);
    }

    public static void logClasspath(ClassLoader classLoader, PrintStream printStream) {
        ClassUtil.outputClasspath(classLoader, printStream);
    }

    public static void logClasspath(ClassLoader classLoader, BcLogger logger) {
        ClassUtil.outputClasspath(classLoader, logger);
    }

    private static void outputClasspath(ClassLoader classLoader, Object outputObject) {
        StringBuilder sb = new StringBuilder();
        if (classLoader instanceof URLClassLoader) {
            sb.append(classLoader.getClass().getName());
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                sb.append(LINE_SEPARATOR).append(url.toString());
            }
        } else {
            sb.append("unable to enumerate entries for ").append(classLoader.getClass().getName());
        }
        if (outputObject instanceof PrintStream) {
            ((PrintStream)outputObject).println(sb.toString());
        } else if (outputObject instanceof BcLogger) {
            ((BcLogger)outputObject).debug(sb.toString(), new Object[0]);
        } else {
            throw new BcException("unexpected outputObject");
        }
        ClassLoader parentClassLoader = classLoader.getParent();
        if (parentClassLoader != null) {
            ClassUtil.outputClasspath(parentClassLoader, outputObject);
        }
    }

    private static Method getDeclaredMethod(Class clazz, String methodName, Class[] parameters) throws NoSuchMethodException {
        return clazz.getDeclaredMethod(methodName, parameters);
    }
}

