/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mware.core.exception.BcException;
import com.mware.core.ingest.video.VideoFrameInfo;
import com.mware.core.ingest.video.VideoPropertyHelper;
import com.mware.core.model.clientapi.dto.ClientApiEdge;
import com.mware.core.model.clientapi.dto.ClientApiEdgeInfo;
import com.mware.core.model.clientapi.dto.ClientApiEdgeWithVertexData;
import com.mware.core.model.clientapi.dto.ClientApiElement;
import com.mware.core.model.clientapi.dto.ClientApiExtendedDataRow;
import com.mware.core.model.clientapi.dto.ClientApiExtendedDataRowId;
import com.mware.core.model.clientapi.dto.ClientApiGeObject;
import com.mware.core.model.clientapi.dto.ClientApiGeoPoint;
import com.mware.core.model.clientapi.dto.ClientApiGeoRect;
import com.mware.core.model.clientapi.dto.ClientApiHistoricalPropertyResults;
import com.mware.core.model.clientapi.dto.ClientApiProperty;
import com.mware.core.model.clientapi.dto.ClientApiVertex;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.MediaBcSchema;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.SandboxStatusUtil;
import com.mware.core.util.StreamUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeInfo;
import com.mware.ge.Element;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.FetchHintsBuilder;
import com.mware.ge.GeObject;
import com.mware.ge.HistoricalPropertyValue;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoRect;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class ClientApiConverter
extends com.mware.core.model.clientapi.util.ClientApiConverter {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(ClientApiConverter.class);
    public static final FetchHints SEARCH_FETCH_HINTS = new FetchHintsBuilder().setIncludeAllProperties(true).setIncludeAllPropertyMetadata(true).setIncludeEdgeLabelsAndCounts(true).setIncludeExtendedDataTableNames(true).build();
    private static final int HISTORICAL_PROPERTY_MAX_SPV_SIZE = 2000;

    public static List<? extends ClientApiGeObject> toClientApi(Iterable<? extends GeObject> geObjects, String workspaceId, Authorizations authorizations) {
        return ClientApiConverter.toClientApi(geObjects, workspaceId, false, authorizations);
    }

    public static List<? extends ClientApiGeObject> toClientApi(Iterable<? extends GeObject> geObjects, String workspaceId, boolean includeEdgeInfos, Authorizations authorizations) {
        ArrayList<ClientApiGeObject> results = new ArrayList<ClientApiGeObject>();
        for (GeObject geObject : geObjects) {
            results.add(ClientApiConverter.toClientApi(geObject, workspaceId, includeEdgeInfos, authorizations));
        }
        return results;
    }

    public static List<ClientApiElement> toClientApiTermMention(Iterable<Property> elements, String workspaceId, boolean includeEdgeInfos, Authorizations authorizations) {
        ArrayList<ClientApiElement> clientApiElements = new ArrayList<ClientApiElement>();
        for (Property element : elements) {
            clientApiElements.add(ClientApiConverter.toClientApiTermMention(element, workspaceId, includeEdgeInfos, authorizations));
        }
        return clientApiElements;
    }

    public static List<ClientApiVertex> toClientApiVertices(Iterable<? extends Vertex> vertices, String workspaceId, Authorizations authorizations) {
        ArrayList<ClientApiVertex> clientApiElements = new ArrayList<ClientApiVertex>();
        for (Vertex vertex : vertices) {
            clientApiElements.add(ClientApiConverter.toClientApiVertex(vertex, workspaceId, authorizations));
        }
        return clientApiElements;
    }

    public static ClientApiGeObject toClientApi(GeObject geObject, String workspaceId, Authorizations authorizations) {
        return ClientApiConverter.toClientApi(geObject, workspaceId, false, authorizations);
    }

    public static ClientApiGeObject toClientApi(GeObject geObject, String workspaceId, boolean includeEdgeInfos, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)geObject, (Object)"geObject cannot be null");
        if (geObject instanceof Vertex) {
            return ClientApiConverter.toClientApiVertex((Vertex)geObject, workspaceId, null, includeEdgeInfos, authorizations);
        }
        if (geObject instanceof Edge) {
            return ClientApiConverter.toClientApiEdge((Edge)geObject, workspaceId);
        }
        if (geObject instanceof ExtendedDataRow) {
            return ClientApiConverter.toClientApiExtendedDataRow((ExtendedDataRow)geObject, workspaceId);
        }
        throw new RuntimeException("Unexpected geObject type: " + geObject.getClass().getName());
    }

    public static ClientApiElement toClientApiTermMention(Property element, String workspaceId, boolean includeEdgeInfos, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)element, (Object)"element cannot be null");
        throw new UnsupportedOperationException("Not implemented");
    }

    public static ClientApiVertex toClientApiVertex(Vertex vertex, String workspaceId, Authorizations authorizations) {
        return ClientApiConverter.toClientApiVertex(vertex, workspaceId, null, authorizations);
    }

    public static ClientApiVertex toClientApiVertex(Vertex vertex, String workspaceId, Integer commonCount, Authorizations authorizations) {
        return ClientApiConverter.toClientApiVertex(vertex, workspaceId, commonCount, false, authorizations);
    }

    public static ClientApiVertex toClientApiVertex(Vertex vertex, String workspaceId, Integer commonCount, boolean includeEdgeInfos, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)vertex, (Object)"vertex is required");
        ClientApiVertex v = new ClientApiVertex();
        if (authorizations != null) {
            StreamUtil.stream(vertex.getEdgeLabels(Direction.BOTH, authorizations)).forEach(v::addEdgeLabel);
            if (includeEdgeInfos) {
                StreamUtil.stream(vertex.getEdgeInfos(Direction.BOTH, authorizations)).map(ClientApiConverter::toClientApi).forEach(v::addEdgeInfo);
            }
        }
        ClientApiConverter.populateClientApiElement(v, vertex, workspaceId);
        ClientApiProperty conceptType = new ClientApiProperty();
        conceptType.setKey("");
        conceptType.setName("conceptType");
        conceptType.setValue(vertex.getConceptType());
        v.getProperties().add(conceptType);
        v.setCommonCount(commonCount);
        return v;
    }

    private static ClientApiEdgeInfo toClientApi(EdgeInfo edgeInfo) {
        return new ClientApiEdgeInfo(edgeInfo.getEdgeId(), edgeInfo.getLabel(), edgeInfo.getVertexId());
    }

    public static ClientApiEdge toClientApiEdge(Edge edge, String workspaceId) {
        ClientApiEdge e = new ClientApiEdge();
        ClientApiConverter.populateClientApiEdge(e, edge, workspaceId);
        return e;
    }

    public static ClientApiEdgeWithVertexData toClientApiEdgeWithVertexData(Edge edge, Vertex source, Vertex target, String workspaceId, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)source, (Object)"source vertex is required");
        Preconditions.checkNotNull((Object)target, (Object)"target vertex is required");
        ClientApiEdgeWithVertexData e = new ClientApiEdgeWithVertexData();
        e.setSource(ClientApiConverter.toClientApiVertex(source, workspaceId, authorizations));
        e.setTarget(ClientApiConverter.toClientApiVertex(target, workspaceId, authorizations));
        ClientApiConverter.populateClientApiEdge(e, edge, workspaceId);
        return e;
    }

    public static void populateClientApiEdge(ClientApiEdge e, Edge edge, String workspaceId) {
        e.setLabel(edge.getLabel());
        e.setOutVertexId(edge.getVertexId(Direction.OUT));
        e.setInVertexId(edge.getVertexId(Direction.IN));
        ClientApiConverter.populateClientApiElement(e, edge, workspaceId);
    }

    private static void populateClientApiElement(ClientApiElement clientApiElement, Element element, String workspaceId) {
        clientApiElement.setId((String)element.getId());
        clientApiElement.getProperties().addAll(ClientApiConverter.toClientApiProperties(element.getProperties(), workspaceId));
        clientApiElement.getExtendedDataTableNames().addAll((Collection<String>)element.getExtendedDataTableNames());
        clientApiElement.setSandboxStatus(SandboxStatusUtil.getSandboxStatus(element, workspaceId));
        VisibilityJson visibilityJson = (VisibilityJson)BcSchema.VISIBILITY_JSON.getPropertyValue(element);
        if (visibilityJson != null) {
            clientApiElement.setVisibilitySource(visibilityJson.getSource());
        }
        if (clientApiElement instanceof ClientApiVertex) {
            ClientApiVertex clientApiVertex = (ClientApiVertex)clientApiElement;
            Vertex vertex = (Vertex)element;
            clientApiVertex.setConceptType(vertex.getConceptType());
        }
    }

    public static List<ClientApiProperty> toClientApiProperties(Iterable<Property> properties, String workspaceId) {
        ArrayList<ClientApiProperty> clientApiProperties = new ArrayList<ClientApiProperty>();
        List<Property> propertiesList = IterableUtils.toList(properties);
        SandboxStatus[] sandboxStatuses = SandboxStatusUtil.getPropertySandboxStatuses(propertiesList, workspaceId);
        for (int i = 0; i < propertiesList.size(); ++i) {
            Property property = propertiesList.get(i);
            SandboxStatus sandboxStatus = sandboxStatuses[i];
            VideoFrameInfo videoFrameInfo = VideoPropertyHelper.getVideoFrameInfoFromProperty(property);
            if (videoFrameInfo != null) {
                String textDescription = BcSchema.TEXT_DESCRIPTION_METADATA.getMetadataValueOrDefault(property.getMetadata(), null);
                ClientApiConverter.addVideoFramePropertyToResults(clientApiProperties, videoFrameInfo.getPropertyKey(), textDescription, sandboxStatus);
                continue;
            }
            ClientApiProperty clientApiProperty = ClientApiConverter.toClientApiProperty(property);
            clientApiProperty.setSandboxStatus(sandboxStatus);
            clientApiProperties.add(clientApiProperty);
        }
        return clientApiProperties;
    }

    public static ClientApiProperty toClientApiProperty(Property property) {
        ClientApiProperty clientApiProperty = new ClientApiProperty();
        clientApiProperty.setKey(property.getKey());
        clientApiProperty.setName(property.getName());
        Value propertyValue = property.getValue();
        if (propertyValue instanceof StreamingPropertyValue) {
            clientApiProperty.setStreamingPropertyValue(true);
        } else {
            clientApiProperty.setValue(ClientApiConverter.toClientApiValue(propertyValue));
        }
        for (Metadata.Entry entry : property.getMetadata().entrySet()) {
            clientApiProperty.getMetadata().put(entry.getKey(), ClientApiConverter.toClientApiValue(entry.getValue()));
        }
        return clientApiProperty;
    }

    private static void addVideoFramePropertyToResults(List<ClientApiProperty> clientApiProperties, String propertyKey, String textDescription, SandboxStatus sandboxStatus) {
        ClientApiProperty clientApiProperty = ClientApiConverter.findProperty(clientApiProperties, MediaBcSchema.VIDEO_TRANSCRIPT.getPropertyName(), propertyKey);
        if (clientApiProperty == null) {
            clientApiProperty = new ClientApiProperty();
            clientApiProperty.setKey(propertyKey);
            clientApiProperty.setName(MediaBcSchema.VIDEO_TRANSCRIPT.getPropertyName());
            clientApiProperty.setSandboxStatus(sandboxStatus);
            clientApiProperty.getMetadata().put(BcSchema.TEXT_DESCRIPTION_METADATA.getMetadataKey(), textDescription);
            clientApiProperty.setStreamingPropertyValue(true);
            clientApiProperties.add(clientApiProperty);
        }
    }

    private static ClientApiProperty findProperty(List<ClientApiProperty> clientApiProperties, String propertyName, String propertyKey) {
        for (ClientApiProperty property : clientApiProperties) {
            if (!property.getName().equals(propertyName) || !property.getKey().equals(propertyKey)) continue;
            return property;
        }
        return null;
    }

    public static ClientApiHistoricalPropertyResults calculateHistoricalPropertyDeltas(Iterable<HistoricalPropertyValue> historicalPropertyValues, Locale locale, ResourceBundle resourceBundle, boolean withVisibility) {
        ClientApiHistoricalPropertyResults result = new ClientApiHistoricalPropertyResults();
        ArrayList sortedHistoricalValues = Lists.newArrayList(historicalPropertyValues);
        sortedHistoricalValues.sort(Collections.reverseOrder());
        HashMap<String, HistoricalPropertyValue> cachedValues = new HashMap<String, HistoricalPropertyValue>();
        int i = 0;
        for (HistoricalPropertyValue hpv : sortedHistoricalValues) {
            String key = hpv.getPropertyKey() + hpv.getPropertyName();
            HistoricalPropertyValue cached = (HistoricalPropertyValue)cachedValues.get(key);
            ClientApiHistoricalPropertyResults.Event event = null;
            if (cached == null) {
                if (hpv.getPropertyName().equals("conceptType")) {
                    HistoricalPropertyValue conceptTypeHpv = hpv;
                    HistoricalPropertyValue modifiedByHpv = (HistoricalPropertyValue)cachedValues.get(BcSchema.MODIFIED_BY.getPropertyName());
                    for (int j = i; modifiedByHpv == null && j < sortedHistoricalValues.size(); ++j) {
                        HistoricalPropertyValue v = (HistoricalPropertyValue)sortedHistoricalValues.get(j);
                        if (!v.getPropertyName().equals(BcSchema.MODIFIED_BY.getPropertyName())) continue;
                        modifiedByHpv = v;
                    }
                    event = ClientApiConverter.generatePropertyAddedEvent(conceptTypeHpv, locale, resourceBundle, withVisibility);
                    if (modifiedByHpv != null) {
                        ClientApiHistoricalPropertyResults.Event modifiedByEvent = ClientApiConverter.generatePropertyAddedEvent(modifiedByHpv, locale, resourceBundle, withVisibility);
                        event.modifiedBy = modifiedByEvent.fields.get("value");
                    }
                } else {
                    event = ClientApiConverter.generatePropertyAddedEvent(hpv, locale, resourceBundle, withVisibility);
                    cachedValues.put(key, hpv);
                }
            } else if (hpv.isDeleted()) {
                if (hpv.isDeleted() != cached.isDeleted()) {
                    event = ClientApiConverter.generatePropertyDeletedEvent(hpv, locale, resourceBundle, withVisibility);
                }
                cachedValues.remove(key);
            } else {
                if (ClientApiConverter.hasHistoricalPropertyChanged(cached, hpv, withVisibility)) {
                    event = ClientApiConverter.generatePropertyModifiedEvent(hpv, cached, locale, resourceBundle, withVisibility);
                } else {
                    LOGGER.debug("Historical property value did not change. Ignore", new Object[0]);
                    LOGGER.debug("  was:" + hpv, new Object[0]);
                }
                cachedValues.put(key, hpv);
            }
            if (event != null) {
                result.events.add(event);
            }
            ++i;
        }
        return result;
    }

    private static ClientApiHistoricalPropertyResults.Event generateGenericEvent(HistoricalPropertyValue hpv) {
        ClientApiHistoricalPropertyResults.Event event = new ClientApiHistoricalPropertyResults.Event();
        event.timestamp = hpv.getTimestamp();
        event.propertyKey = hpv.getPropertyKey();
        event.propertyName = hpv.getPropertyName();
        Metadata.Entry modifiedByEntry = hpv.getMetadata() != null ? hpv.getMetadata().getEntry(BcSchema.MODIFIED_BY.getPropertyName()) : null;
        event.modifiedBy = modifiedByEntry != null ? ClientApiConverter.toClientApiValue(modifiedByEntry.getValue()).toString() : null;
        return event;
    }

    private static ClientApiHistoricalPropertyResults.Event generatePropertyAddedEvent(HistoricalPropertyValue hpv, Locale locale, ResourceBundle resourceBundle, boolean withVisibility) {
        ClientApiHistoricalPropertyResults.Event event = ClientApiConverter.generateGenericEvent(hpv);
        event.setEventType(ClientApiHistoricalPropertyResults.EventType.PROPERTY_ADDED);
        HashMap<String, String> fields = new HashMap<String, String>();
        Object value = hpv.getValue();
        if (value instanceof StreamingPropertyValue) {
            value = ClientApiConverter.readStreamingPropertyValueForHistory((StreamingPropertyValue)value, locale, resourceBundle);
        }
        fields.put("value", ClientApiConverter.toClientApiValue(value).toString());
        if (withVisibility) {
            fields.put("visibility", ClientApiConverter.removeWorkspaceVisibility(hpv.getPropertyVisibility().getVisibilityString()));
        }
        event.fields = fields;
        event.changed = null;
        return event;
    }

    private static ClientApiHistoricalPropertyResults.Event generatePropertyDeletedEvent(HistoricalPropertyValue hpv, Locale locale, ResourceBundle resourceBundle, boolean withVisibility) {
        ClientApiHistoricalPropertyResults.Event event = ClientApiConverter.generateGenericEvent(hpv);
        event.setEventType(ClientApiHistoricalPropertyResults.EventType.PROPERTY_DELETED);
        HashMap fields = new HashMap();
        HashMap<String, String> changed = new HashMap<String, String>();
        Object value = hpv.getValue();
        if (value != null) {
            if (value instanceof StreamingPropertyValue) {
                value = ClientApiConverter.readStreamingPropertyValueForHistory((StreamingPropertyValue)value, locale, resourceBundle);
            }
            changed.put("value", ClientApiConverter.toClientApiValue(value).toString());
        }
        if (withVisibility) {
            changed.put("visibility", ClientApiConverter.removeWorkspaceVisibility(hpv.getPropertyVisibility().getVisibilityString()));
        }
        event.fields = null;
        event.changed = changed;
        return event;
    }

    private static ClientApiHistoricalPropertyResults.Event generatePropertyModifiedEvent(HistoricalPropertyValue hpv, HistoricalPropertyValue cached, Locale locale, ResourceBundle resourceBundle, boolean withVisibility) {
        ClientApiHistoricalPropertyResults.Event event = ClientApiConverter.generateGenericEvent(hpv);
        event.setEventType(ClientApiHistoricalPropertyResults.EventType.PROPERTY_MODIFIED);
        HashMap<String, String> fields = new HashMap<String, String>();
        HashMap<String, String> changed = new HashMap<String, String>();
        Object value = hpv.getValue();
        if (value instanceof StreamingPropertyValue) {
            value = ClientApiConverter.readStreamingPropertyValueForHistory((StreamingPropertyValue)value, locale, resourceBundle);
        }
        fields.put("value", ClientApiConverter.toClientApiValue(value).toString());
        if (!hpv.getValue().equals(cached.getValue())) {
            changed.put("value", ClientApiConverter.toClientApiValue(cached.getValue()).toString());
        }
        if (withVisibility) {
            String currentVis = ClientApiConverter.removeWorkspaceVisibility(hpv.getPropertyVisibility().getVisibilityString());
            String previousVis = ClientApiConverter.removeWorkspaceVisibility(cached.getPropertyVisibility().getVisibilityString());
            fields.put("visibility", currentVis);
            if (!currentVis.equals(previousVis)) {
                changed.put("visibility", previousVis);
            }
        }
        event.fields = fields;
        event.changed = changed;
        return event;
    }

    private static boolean hasHistoricalPropertyChanged(HistoricalPropertyValue previous, HistoricalPropertyValue current, boolean withVisibility) {
        if (!current.getValue().equals(previous.getValue())) {
            return true;
        }
        String currentVis = ClientApiConverter.removeWorkspaceVisibility(current.getPropertyVisibility().getVisibilityString());
        String previousVis = ClientApiConverter.removeWorkspaceVisibility(previous.getPropertyVisibility().getVisibilityString());
        return withVisibility && !currentVis.equals(previousVis);
    }

    public static ClientApiHistoricalPropertyResults toClientApi(Iterable<HistoricalPropertyValue> historicalPropertyValues, Locale locale, ResourceBundle resourceBundle, boolean withVisibility) {
        return ClientApiConverter.calculateHistoricalPropertyDeltas(historicalPropertyValues, locale, resourceBundle, withVisibility);
    }

    private static String readStreamingPropertyValueForHistory(StreamingPropertyValue spv, Locale locale, ResourceBundle resourceBundle) {
        if (TextValue.class.isAssignableFrom(spv.getValueType())) {
            return ClientApiConverter.readStreamingPropertyValueStringForHistory(spv);
        }
        return String.format(locale, resourceBundle.getString("history.nondisplayable"), spv.getLength());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readStreamingPropertyValueStringForHistory(StreamingPropertyValue spv) {
        try (InputStream in = spv.getInputStream();){
            byte[] buffer = new byte[2000];
            int bytesRead = in.read(buffer, 0, 2000);
            if (bytesRead < 0) {
                String string = "";
                return string;
            }
            String string = new String(buffer, 0, bytesRead);
            return string;
        }
        catch (IOException ex) {
            throw new BcException("Could not read StreamingPropertyValue", ex);
        }
    }

    public static ClientApiGeoPoint toClientApiGeoPoint(GeoPoint geoPoint) {
        return new ClientApiGeoPoint(geoPoint.getLatitude(), geoPoint.getLongitude());
    }

    public static ClientApiGeoRect toClientApiGeoRect(GeoRect rect) {
        return new ClientApiGeoRect(ClientApiConverter.toClientApiGeoPoint(rect.getNorthWest()), ClientApiConverter.toClientApiGeoPoint(rect.getSouthEast()));
    }

    public static String removeWorkspaceVisibility(String visibility) {
        return Arrays.stream(visibility.split("\\|")).map(s -> s.replaceAll("&?\\(WORKSPACE_.*?\\)", "").replace("administrator", "")).filter(s -> s.length() > 0 && !s.equals("()")).collect(Collectors.joining("|"));
    }

    public static List<ClientApiExtendedDataRow> toClientApiExtendedDataRows(Iterable<ExtendedDataRow> rows) {
        return StreamUtil.stream(rows).map(ClientApiConverter::toClientApiExtendedDataRow).collect(Collectors.toList());
    }

    public static ClientApiExtendedDataRow toClientApiExtendedDataRow(ExtendedDataRow row) {
        return ClientApiConverter.toClientApiExtendedDataRow(row, null);
    }

    public static ClientApiExtendedDataRow toClientApiExtendedDataRow(ExtendedDataRow row, String workspaceId) {
        ClientApiExtendedDataRow results = new ClientApiExtendedDataRow(ClientApiConverter.toClientApiExtendedDataRowId(row.getId()));
        results.getProperties().addAll(ClientApiConverter.toClientApiProperties(row.getProperties(), workspaceId));
        return results;
    }

    public static ClientApiExtendedDataRowId toClientApiExtendedDataRowId(ExtendedDataRowId id) {
        return new ClientApiExtendedDataRowId(id.getElementType().name(), id.getElementId(), id.getTableName(), id.getRowId());
    }

    public static JSONObject clientApiToJSONObject(Object obj) {
        return new JSONObject(ClientApiConverter.clientApiToString(obj));
    }

    public static Long toClientApiDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public static Long toClientApiDate(ZonedDateTime date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().toEpochMilli();
    }
}

