/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import com.mware.core.exception.BcException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration {
    private static final Pattern BASIC_PATTERN = Pattern.compile("([-0-9\\.]+)[\\s*](.*)");
    private double time;
    private TimeUnit timeUnit;

    public Duration(double time, TimeUnit timeUnit) {
        this.time = time;
        this.timeUnit = timeUnit;
    }

    public Date addTo(Date date) {
        return new Date((long)((double)date.getTime() + this.getTimeInMillis()));
    }

    public double getTimeInMillis() {
        switch (this.timeUnit) {
            case NANOSECONDS: {
                return this.time / 1000.0 / 1000.0;
            }
            case MICROSECONDS: {
                return this.time / 1000.0;
            }
            case MILLISECONDS: {
                return this.time;
            }
            case SECONDS: {
                return this.time * 1000.0;
            }
            case MINUTES: {
                return this.time * 1000.0 * 60.0;
            }
            case HOURS: {
                return this.time * 1000.0 * 60.0 * 60.0;
            }
            case DAYS: {
                return this.time * 1000.0 * 60.0 * 60.0 * 24.0;
            }
        }
        throw new BcException("Unhandled time unit: " + (Object)((Object)this.timeUnit));
    }

    public String toString() {
        return "Duration{" + this.time + " " + (Object)((Object)this.timeUnit) + "}";
    }

    public static Duration parse(String str) {
        if ((str = str.trim()).equals("0")) {
            return new Duration(0.0, TimeUnit.MILLISECONDS);
        }
        Matcher m = BASIC_PATTERN.matcher(str);
        if (!m.matches()) {
            throw new BcException("Could not parse duration string: " + str);
        }
        try {
            double time = Double.parseDouble(m.group(1));
            TimeUnit timeUnit = Duration.parseTimeUnit(m.group(2));
            return new Duration(time, timeUnit);
        }
        catch (Exception ex) {
            throw new BcException("Could not parse duration string: " + str, ex);
        }
    }

    private static TimeUnit parseTimeUnit(String timeUnitString) {
        if (!timeUnitString.endsWith("s")) {
            timeUnitString = timeUnitString + "s";
        }
        timeUnitString = timeUnitString.toUpperCase();
        return TimeUnit.valueOf(timeUnitString);
    }
}

