/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import com.mware.core.exception.BcException;
import java.util.ArrayList;
import java.util.List;

public class FixedSizeCircularLinkedList<T> {
    private Node<T> head;

    public FixedSizeCircularLinkedList(int size, Class<T> type) {
        this.head = new Node<T>(0, null, type);
        Node<T> first = this.head;
        for (int i = 1; i < size; ++i) {
            this.head = new Node<T>(i, this.head, type);
        }
        this.head.setNext(first.setPrevious(this.head));
        this.head = first;
    }

    public T head() {
        return this.head.getData();
    }

    public void rotateForward() {
        this.head = this.head.getNext();
    }

    public List<T> readBackward(int count) {
        ArrayList<T> data = new ArrayList<T>(count);
        Node<T> node = this.head.getPrevious();
        for (int i = 0; i < count; ++i) {
            data.add(node.getData());
            node = node.getPrevious();
        }
        return data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Node<T> node = this.head; first || node != this.head; node = node.getNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(node).append(":").append(node.getData());
        }
        return sb.toString();
    }

    private class Node<t> {
        private Node<t> previous;
        private Node<t> next;
        private int id;
        private t data;

        protected Node(int id, Node<t> previous, Class<t> type) {
            this.id = id;
            if (previous != null) {
                this.previous = previous;
                previous.setNext(this);
            }
            try {
                this.data = type.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new BcException("error creating new instance of type", iae);
            }
            catch (InstantiationException ie) {
                throw new BcException("error creating new instance of type", ie);
            }
        }

        protected Node<t> setPrevious(Node<t> previous) {
            this.previous = previous;
            return this;
        }

        protected Node<t> setNext(Node<t> next) {
            this.next = next;
            return this;
        }

        protected Node<t> getPrevious() {
            return this.previous;
        }

        protected Node<t> getNext() {
            return this.next;
        }

        protected t getData() {
            return this.data;
        }

        public String toString() {
            return Integer.toString(this.id);
        }
    }
}

