/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import com.mware.core.util.BcLogger;
import com.mware.ge.util.CloseableUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;

public class LoggingThread
extends Thread {
    private InputStream inputStream;
    private OutputStream outputStream;
    private StringBuffer contentBuffer;
    private String prefix;
    private PrintWriter writer;
    private BcLogger logger;

    public LoggingThread(InputStream inputStream, BcLogger logger, String prefix) {
        this(inputStream, null, logger, null, prefix);
    }

    public LoggingThread(InputStream inputStream, OutputStream redirect, BcLogger logger, StringBuffer contentBuffer, String prefix) {
        this.inputStream = inputStream;
        this.outputStream = redirect;
        this.logger = logger;
        this.contentBuffer = contentBuffer;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader isreader;
        BufferedReader reader;
        block7: {
            reader = null;
            isreader = null;
            try {
                String line;
                if (this.outputStream != null) {
                    this.writer = new PrintWriter(this.outputStream);
                }
                isreader = new InputStreamReader(this.inputStream);
                reader = new BufferedReader(isreader);
                while ((line = reader.readLine()) != null) {
                    if (this.prefix != null) {
                        line = this.prefix + line;
                    }
                    this.append(line);
                    this.log(line);
                }
                if (this.writer == null) break block7;
                this.writer.flush();
            }
            catch (IOException ioe) {
                try {
                    ioe.printStackTrace();
                }
                catch (Throwable throwable) {
                    CloseableUtils.closeQuietly(reader);
                    CloseableUtils.closeQuietly(isreader);
                    CloseableUtils.closeQuietly(this.writer);
                    throw throwable;
                }
                CloseableUtils.closeQuietly(reader);
                CloseableUtils.closeQuietly(isreader);
                CloseableUtils.closeQuietly(this.writer);
            }
        }
        CloseableUtils.closeQuietly(reader);
        CloseableUtils.closeQuietly(isreader);
        CloseableUtils.closeQuietly(this.writer);
    }

    protected void append(String output) {
        if (this.writer != null) {
            this.writer.println(output);
        }
        if (this.contentBuffer != null) {
            this.contentBuffer.append(output.trim());
            this.contentBuffer.append('\n');
        }
    }

    protected void log(String output) {
        if (this.logger != null) {
            this.logger.info("%s", output);
        }
    }
}

