/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import com.mware.core.util.BcLogger;
import com.mware.core.util.FixedSizeCircularLinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MetricReportingExecutorService
extends ThreadPoolExecutor {
    private BcLogger logger;
    private ScheduledExecutorService scheduledExecutorService;
    private FixedSizeCircularLinkedList<AtomicInteger> executionCount;
    private FixedSizeCircularLinkedList<AtomicInteger> maxActive;
    private FixedSizeCircularLinkedList<AtomicInteger> maxWaiting;

    public MetricReportingExecutorService(BcLogger logger, int nThreads) {
        super(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.logger = logger;
        this.executionCount = new FixedSizeCircularLinkedList<AtomicInteger>(16, AtomicInteger.class);
        this.maxActive = new FixedSizeCircularLinkedList<AtomicInteger>(16, AtomicInteger.class);
        this.maxWaiting = new FixedSizeCircularLinkedList<AtomicInteger>(16, AtomicInteger.class);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MetricReportingExecutorService.this.tick();
            }
        }, 1L, 1L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MetricReportingExecutorService.this.report();
            }
        }, 1L, 5L, TimeUnit.MINUTES);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        int currentMaxWaiting;
        int waiting;
        super.beforeExecute(t, r);
        this.executionCount.head().incrementAndGet();
        int active = this.getActiveCount();
        int currentMaxActive = this.maxActive.head().get();
        if (active > currentMaxActive) {
            this.maxActive.head().set(active);
        }
        if ((waiting = this.getQueue().size()) > (currentMaxWaiting = this.maxWaiting.head().get())) {
            this.maxWaiting.head().set(waiting);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
    }

    public void tick() {
        this.executionCount.rotateForward();
        this.executionCount.head().set(0);
        this.maxActive.rotateForward();
        this.maxActive.head().set(0);
        this.maxWaiting.rotateForward();
        this.maxWaiting.head().set(0);
    }

    public void report() {
        List<AtomicInteger> executionCountList = this.executionCount.readBackward(15);
        List<AtomicInteger> maxActiveList = this.maxActive.readBackward(15);
        List<AtomicInteger> maxWaitingList = this.maxWaiting.readBackward(15);
        this.report("executions: ", executionCountList);
        this.report("max active: ", maxActiveList);
        this.report("max waiting:", maxWaitingList);
    }

    private void report(String label, List<AtomicInteger> list) {
        int one = list.get(0).get();
        int five = 0;
        int fifteen = 0;
        for (int i = 0; i < 15; ++i) {
            int value = list.get(i).get();
            if (i < 5) {
                five += value;
            }
            fifteen += value;
        }
        this.logger.debug("%s %3d / %6.2f / %6.2f", label, one, (double)five / 5.0, (double)fifteen / 15.0);
    }

    @Override
    public void shutdown() {
        this.scheduledExecutorService.shutdown();
        super.shutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.scheduledExecutorService.awaitTermination(timeout, unit);
        return super.awaitTermination(timeout, unit);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.scheduledExecutorService.shutdownNow();
        return super.shutdownNow();
    }
}

