/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import com.mware.core.exception.BcException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class Pipe {
    private static ExecutorService executor = Executors.newFixedThreadPool(5);
    private Semaphore completionSemaphore = new Semaphore(1);

    public Pipe pipe(final InputStream in, final OutputStream out, final StatusHandler statusHandler) {
        final boolean[] threadStarted = new boolean[]{false};
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    int read;
                    byte[] buffer = new byte[0x100000];
                    Pipe.this.completionSemaphore.acquire();
                    threadStarted[0] = true;
                    while ((read = in.read(buffer)) > 0) {
                        out.write(buffer, 0, read);
                    }
                }
                catch (IOException e) {
                    statusHandler.handleException(e);
                }
                catch (InterruptedException e) {
                    statusHandler.handleException(e);
                }
                finally {
                    threadStarted[0] = true;
                    statusHandler.handleComplete();
                    Pipe.this.completionSemaphore.release();
                }
            }
        });
        while (!threadStarted[0]) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new BcException("Could not sleep", e);
            }
        }
        return this;
    }

    public void waitForCompletion(long timeout, TimeUnit units) throws InterruptedException {
        this.completionSemaphore.tryAcquire(timeout, units);
    }

    public static class StatusHandler {
        public void handleException(Exception e) {
        }

        public void handleComplete() {
        }
    }
}

