/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;

public class ProcessUtil {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(ProcessUtil.class);

    public static String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int i = name.indexOf(64);
        if (i > 0) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return false;
        }
        return os.toLowerCase().startsWith("windows");
    }

    public static int getPid(Process p) {
        int pid = 0;
        if (p.getClass().getName().equals("java.lang.UNIXProcess") || p.getClass().getName().equals("java.lang.ProcessImpl")) {
            try {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getInt(p);
            }
            catch (Throwable e) {
                LOGGER.error("Failure trying to get pid from " + p, e);
            }
        }
        return pid;
    }
}

