/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;

public class RowKeyHelper {
    public static final char FIELD_SEPARATOR = '\u001d';
    public static final int OFFSET_WIDTH = 16;

    public static String build(String ... parts) {
        return StringUtils.join((Object[])parts, (char)'\u001d');
    }

    public static String buildSHA256KeyString(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] sha = digest.digest(bytes);
            return "urn\u001dsha256\u001d" + Hex.encodeHexString((byte[])sha);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildSHA256KeyString(InputStream in) throws IOException {
        try {
            int read;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            int bufferSize = 4096;
            byte[] buffer = new byte[bufferSize];
            while ((read = in.read(buffer, 0, buffer.length)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] sha = digest.digest();
            return "urn\u001dsha256\u001d" + Hex.encodeHexString((byte[])sha);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] splitOnMinorFieldSeparator(String rowKey) {
        return rowKey.split("\u001d");
    }

    public static String fromDate(Date date) {
        SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        return DATE_TIME_FORMAT.format(date);
    }
}

