/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Element;
import com.mware.ge.Property;
import java.util.Collection;
import java.util.List;

public class SandboxStatusUtil {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(SandboxStatusUtil.class);

    public static SandboxStatus getSandboxStatus(Element element, String workspaceId) {
        VisibilityJson visibilityJson = (VisibilityJson)BcSchema.VISIBILITY_JSON.getPropertyValue(element);
        return SandboxStatus.getFromVisibilityJsonString(visibilityJson, workspaceId);
    }

    public static SandboxStatus[] getPropertySandboxStatuses(List<Property> properties, String workspaceId) {
        Property property;
        int i;
        SandboxStatus[] sandboxStatuses = new SandboxStatus[properties.size()];
        for (i = 0; i < properties.size(); ++i) {
            property = properties.get(i);
            Collection<VisibilityJson> visibilityJsons = BcSchema.VISIBILITY_JSON_METADATA.getMetadataValues(property.getMetadata());
            if (visibilityJsons.size() > 1) {
                // empty if block
            }
            sandboxStatuses[i] = SandboxStatusUtil.getMostExclusiveSandboxStatus(visibilityJsons, workspaceId);
        }
        for (i = 0; i < properties.size(); ++i) {
            property = properties.get(i);
            if (sandboxStatuses[i] != SandboxStatus.PRIVATE) continue;
            for (int j = 0; j < properties.size(); ++j) {
                Property p = properties.get(j);
                if (i == j || sandboxStatuses[j] != SandboxStatus.PUBLIC || sandboxStatuses[i] != SandboxStatus.PRIVATE || !property.getKey().equals(p.getKey()) || !property.getName().equals(p.getName())) continue;
                sandboxStatuses[i] = SandboxStatus.PUBLIC_CHANGED;
            }
        }
        return sandboxStatuses;
    }

    private static SandboxStatus getMostExclusiveSandboxStatus(Collection<VisibilityJson> visibilityJsons, String workspaceId) {
        for (VisibilityJson visibilityJson : visibilityJsons) {
            SandboxStatus status = SandboxStatus.getFromVisibilityJsonString(visibilityJson, workspaceId);
            switch (status) {
                case PUBLIC: {
                    break;
                }
                case PUBLIC_CHANGED: 
                case PRIVATE: {
                    return status;
                }
            }
        }
        return SandboxStatus.PUBLIC;
    }
}

