/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class SourceInfoSnippetSanitizer {
    private static Pattern snippetPattern = Pattern.compile("^(.*?)<span class=\"selection\">(.+?)</span>(.*)$", 32);

    public static String sanitizeSnippet(String snippet) {
        if (snippet == null) {
            return null;
        }
        Matcher matcher = snippetPattern.matcher(snippet);
        if (matcher.matches() && matcher.groupCount() == 3) {
            String prefix = matcher.group(1);
            String selection = matcher.group(2);
            String suffix = matcher.group(3);
            return SourceInfoSnippetSanitizer.escapeParts(prefix, selection, suffix);
        }
        return StringEscapeUtils.escapeXml11((String)snippet);
    }

    private static String escapeParts(String prefix, String selection, String suffix) {
        StringBuilder str = new StringBuilder();
        str.append(StringEscapeUtils.escapeXml11((String)prefix));
        str.append("<span class=\"selection\">");
        str.append(StringEscapeUtils.escapeXml11((String)selection));
        str.append("</span>");
        str.append(StringEscapeUtils.escapeXml11((String)suffix));
        return str.toString();
    }
}

