/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mware.core.exception.BcException;
import com.mware.ge.Element;
import com.mware.ge.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtil {
    private StreamUtil() {
    }

    public static Stream<Element> stream(Query ... queries) {
        return Arrays.stream(queries).map(query -> StreamSupport.stream(query.elements().spliterator(), false)).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    @SafeVarargs
    public static <T> Stream<T> stream(Iterable<T> ... iterables) {
        List<Iterator> iterators = Arrays.stream(iterables).map(Iterable::iterator).collect(Collectors.toList());
        return StreamUtil.stream(iterators.toArray(new Iterator[iterables.length]));
    }

    @SafeVarargs
    public static <T> Stream<T> stream(Iterator<T> ... iterators) {
        return StreamUtil.withCloseHandler(Arrays.stream(iterators).map(StreamUtil::streamForIterator).reduce(Stream::concat).orElseGet(Stream::empty), iterators);
    }

    @SafeVarargs
    private static <T> Stream<T> withCloseHandler(Stream<T> stream, Iterator<T> ... iterators) {
        stream.onClose(() -> {
            for (Iterator iterator : iterators) {
                if (!(iterator instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)((Object)iterator)).close();
                }
                catch (Exception ex) {
                    throw new BcException(String.format("exception occurred when closing %s", iterator.getClass().getName()), ex);
                }
            }
        });
        return stream;
    }

    public static <T> Stream<T> streamForIterator(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }

    public static <T> Collector<T, ImmutableList.Builder<T>, ImmutableList<T>> toImmutableList() {
        return Collector.of(ImmutableList.Builder::new, ImmutableList.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableList.Builder::build, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ImmutableSet.Builder<T>, ImmutableSet<T>> toImmutableSet() {
        return Collector.of(ImmutableSet.Builder::new, ImmutableSet.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableSet.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K, V> Collector<T, ImmutableMap.Builder<K, V>, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collector.of(ImmutableMap.Builder::new, (r, t) -> r.put(keyMapper.apply(t), valueMapper.apply(t)), (l, r) -> l.putAll((Map)r.build()), ImmutableMap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, A, R> Collector<T, ?, R> unorderedBatches(int batchSize, Collector<List<T>, A, R> downstream) {
        class Acc {
            List<T> cur = new ArrayList();
            A acc = this.val$downstream.supplier().get();
            final /* synthetic */ Collector val$downstream;

            Acc(Collector collector) {
                this.val$downstream = collector;
            }
        }
        BiConsumer<Acc, Object> accumulator = (acc, t) -> {
            acc.cur.add(t);
            if (acc.cur.size() == batchSize) {
                downstream.accumulator().accept(acc.acc, acc.cur);
                acc.cur = new ArrayList();
            }
        };
        return Collector.of(() -> new Acc(downstream), accumulator, (acc1, acc2) -> {
            acc1.acc = downstream.combiner().apply(acc1.acc, acc2.acc);
            for (Object t : acc2.cur) {
                accumulator.accept((Acc)acc1, t);
            }
            return acc1;
        }, acc -> {
            if (!acc.cur.isEmpty()) {
                downstream.accumulator().accept(acc.acc, acc.cur);
            }
            return downstream.finisher().apply(acc.acc);
        }, Collector.Characteristics.UNORDERED);
    }
}

