/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import java.util.concurrent.Callable;

public abstract class TimingCallable<V>
implements Callable<V> {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(TimingCallable.class);
    private final String message;

    public TimingCallable(String message) {
        this.message = message;
    }

    @Override
    public final V call() throws Exception {
        long startTime = System.currentTimeMillis();
        V result = this.callWithTime();
        long endTime = System.currentTimeMillis();
        LOGGER.debug("time for %s: %dms", this.message, endTime - startTime);
        return result;
    }

    protected abstract V callWithTime() throws Exception;
}

