/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.watcher;

import com.mware.ge.Element;
import com.mware.ge.event.AddPropertyEvent;
import com.mware.ge.event.DeletePropertyEvent;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.MarkHiddenPropertyEvent;
import com.mware.ge.event.MarkVisiblePropertyEvent;
import com.mware.ge.event.SoftDeletePropertyEvent;

public class PropertyEvent {
    public static final String ADD_PROPERTY_EVENT_TYPE = "Add Property";
    public static final String DELETE_PROPERTY_EVENT_TYPE = "Delete Property";
    public static final String MARK_HIDDEN_PROPERTY_EVENT_TYPE = "Mark Hidden Property";
    public static final String MARK_VISIBLE_PROPERTY_EVENT_TYPE = "Mark Visible Property";
    public static final String SOFT_DELETE_PROPERTY_EVENT_TYPE = "Soft Delete Property";
    private GraphEvent event;
    private String eventType;
    private boolean valid;
    private Element element;
    private String propertyName;

    public PropertyEvent(GraphEvent event) {
        this.event = event;
        this.buildEvent();
    }

    private void buildEvent() {
        if (this.event == null) {
            return;
        }
        this.setValid(true);
        if (this.event instanceof AddPropertyEvent) {
            this.setEventType(ADD_PROPERTY_EVENT_TYPE);
            AddPropertyEvent _event = (AddPropertyEvent)this.event;
            this.setElement(_event.getElement());
            this.setPropertyName(_event.getProperty().getName());
        } else if (this.event instanceof DeletePropertyEvent) {
            this.setEventType(DELETE_PROPERTY_EVENT_TYPE);
            DeletePropertyEvent _event = (DeletePropertyEvent)this.event;
            this.setElement(_event.getElement());
            this.setPropertyName(_event.getName());
        } else if (this.event instanceof MarkHiddenPropertyEvent) {
            this.setEventType(MARK_HIDDEN_PROPERTY_EVENT_TYPE);
            MarkHiddenPropertyEvent _event = (MarkHiddenPropertyEvent)this.event;
            this.setElement(_event.getElement());
            this.setPropertyName(_event.getProperty().getName());
        } else if (this.event instanceof MarkVisiblePropertyEvent) {
            this.setEventType(MARK_VISIBLE_PROPERTY_EVENT_TYPE);
            MarkVisiblePropertyEvent _event = (MarkVisiblePropertyEvent)this.event;
            this.setElement(_event.getElement());
            this.setPropertyName(_event.getProperty().getName());
        } else if (this.event instanceof SoftDeletePropertyEvent) {
            this.setEventType(SOFT_DELETE_PROPERTY_EVENT_TYPE);
            SoftDeletePropertyEvent _event = (SoftDeletePropertyEvent)this.event;
            this.setElement(_event.getElement());
            this.setPropertyName(_event.getName());
        } else {
            this.setValid(false);
        }
    }

    public GraphEvent getEvent() {
        return this.event;
    }

    public void setEvent(GraphEvent event) {
        this.event = event;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }
}

