/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.watcher;

import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.email.EmailRepository;
import com.mware.core.model.notification.ExpirationAge;
import com.mware.core.model.notification.ExpirationAgeUnit;
import com.mware.core.model.notification.UserNotificationRepository;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.watcher.Watch;
import com.mware.core.model.watcher.WatchlistRepository;
import com.mware.core.user.User;
import com.mware.core.watcher.EdgeEvent;
import com.mware.core.watcher.EmailValidator;
import com.mware.core.watcher.PropertyEvent;
import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.Vertex;
import com.mware.ge.event.AddPropertyEvent;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class WatcherGraphListener
extends GraphEventListener {
    private static final int WATCH_NOTIFICATION_DEFAULT_EXPIRATION_AGE = 10;
    private static final String DEFAULT_EMAIL_FROM = "amplexor@sparksc.com";
    private static final boolean ENABLE_MAIL_NOTIFICATION = true;
    private static final List<String> propertiesToIgnore = new ArrayList<String>();
    private UserNotificationRepository userNotificationRepository;
    private EmailRepository emailRepository;
    private UserRepository userRepository;
    private WatchlistRepository watchlistRepository;
    private User systemUser;

    @Override
    public void onGraphEvent(GraphEvent graphEvent) {
        if (graphEvent instanceof AddPropertyEvent && ((AddPropertyEvent)graphEvent).getProperty() == null) {
            return;
        }
        PropertyEvent event = new PropertyEvent(graphEvent);
        if (event.isValid()) {
            this.onPropertyEvent(event);
        } else {
            EdgeEvent eevent = new EdgeEvent(graphEvent);
            if (eevent.isValid()) {
                this.onEdgeEvent(eevent);
            }
        }
    }

    private void onPropertyEvent(PropertyEvent event) {
        String propertyName = event.getPropertyName();
        for (String prop : propertiesToIgnore) {
            if (!propertyName.endsWith(prop)) continue;
            return;
        }
        Stream<Watch> watchStream = this.getWatchlistRepository().getElementWatches((String)event.getElement().getId());
        watchStream.filter(watch -> watch.getPropertyName().equals(event.getPropertyName())).forEach(watch -> this.notifyUser(watch.getUserId(), "Watch alert on element with title: " + (String)BcSchema.TITLE.getFirstPropertyValue(event.getElement()), "Property: " + event.getPropertyName() + " changed with event: " + event.getEventType()));
    }

    private void onEdgeEvent(EdgeEvent event) {
        Edge edge = event.getEdge();
        Authorizations authorizations = edge.getAuthorizations();
        Vertex inVertex = edge.getVertices(authorizations).getInVertex();
        Vertex outVertex = edge.getVertices(authorizations).getOutVertex();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        vertices.add(inVertex);
        String sourceTitle = (String)BcSchema.TITLE.getFirstPropertyValue(inVertex);
        vertices.add(outVertex);
        String destTitle = (String)BcSchema.TITLE.getFirstPropertyValue(outVertex);
        for (Vertex vertex : vertices) {
            Stream<Watch> watchStream = this.getWatchlistRepository().getElementWatches((String)vertex.getId());
            watchStream.filter(watch -> watch.getPropertyName().equals(event.getTitle())).forEach(watch -> this.notifyUser(watch.getUserId(), "Watch alert on relationship with title: " + event.getTitle(), "Relationship: " + event.getTitle() + " between " + (sourceTitle == null ? "-" : sourceTitle) + " and " + (destTitle == null ? "-" : destTitle) + " changed with event: " + event.getEventType()));
        }
    }

    private void notifyUser(String userId, String title, String message) {
        User user = this.getUserRepository().findById(userId);
        this.getUserNotificationRepository().createNotification(userId, title, message, null, new ExpirationAge(10, ExpirationAgeUnit.MINUTE), this.getSystemUser());
        if (EmailValidator.getInstance().validate(user.getUsername()) || EmailValidator.getInstance().validate(user.getEmailAddress())) {
            this.getEmailRepository().send(DEFAULT_EMAIL_FROM, EmailValidator.getInstance().validate(user.getEmailAddress()) ? user.getEmailAddress() : user.getUsername(), title, message);
        }
    }

    private User getSystemUser() {
        if (this.systemUser == null) {
            this.systemUser = this.getUserRepository().getSystemUser();
        }
        return this.systemUser;
    }

    private WatchlistRepository getWatchlistRepository() {
        if (this.watchlistRepository == null) {
            this.watchlistRepository = InjectHelper.getInstance(WatchlistRepository.class);
        }
        return this.watchlistRepository;
    }

    private UserRepository getUserRepository() {
        if (this.userRepository == null) {
            this.userRepository = InjectHelper.getInstance(UserRepository.class);
        }
        return this.userRepository;
    }

    private UserNotificationRepository getUserNotificationRepository() {
        if (this.userNotificationRepository == null) {
            this.userNotificationRepository = InjectHelper.getInstance(UserNotificationRepository.class);
        }
        return this.userNotificationRepository;
    }

    private EmailRepository getEmailRepository() {
        if (this.emailRepository == null) {
            this.emailRepository = InjectHelper.getInstance(EmailRepository.class);
        }
        return this.emailRepository;
    }

    static {
        propertiesToIgnore.add("addRelatedConceptWhiteList");
        propertiesToIgnore.add("addable");
        propertiesToIgnore.add("boost");
        propertiesToIgnore.add("color");
        propertiesToIgnore.add("deleteable");
        propertiesToIgnore.add("dependentPropertyIri");
        propertiesToIgnore.add("dependentPropertyIris");
        propertiesToIgnore.add("displayFormula");
        propertiesToIgnore.add("displayName");
        propertiesToIgnore.add("displayType");
        propertiesToIgnore.add("glyphIconFileName");
        propertiesToIgnore.add("intent");
        propertiesToIgnore.add("mapGlyphIconFileName");
        propertiesToIgnore.add("objectPropertyDomain");
        propertiesToIgnore.add("possibleValues");
        propertiesToIgnore.add("propertyGroup");
        propertiesToIgnore.add("searchable");
        propertiesToIgnore.add("sortable");
        propertiesToIgnore.add("subtitleFormula");
        propertiesToIgnore.add("textIndexHints");
        propertiesToIgnore.add("timeFormula");
        propertiesToIgnore.add("titleFormula");
        propertiesToIgnore.add("updateable");
        propertiesToIgnore.add("userVisible");
        propertiesToIgnore.add("validationFormula");
        propertiesToIgnore.add("analyticsvisible");
        propertiesToIgnore.add("searchFacet");
        propertiesToIgnore.add("systemProperty");
        propertiesToIgnore.add("aggType");
        propertiesToIgnore.add("aggPrecision");
        propertiesToIgnore.add("aggInterval");
        propertiesToIgnore.add("aggMinDocumentCount");
        propertiesToIgnore.add("aggTimeZone");
        propertiesToIgnore.add("aggCalendarField");
        propertiesToIgnore.add("glyphIcon");
        propertiesToIgnore.add("ontologyFile");
        propertiesToIgnore.add("ontologyTitle");
        propertiesToIgnore.add("conceptType");
        propertiesToIgnore.add("dataType");
    }
}

