/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.GeException;
import com.mware.ge.Visibility;
import com.mware.ge.security.ColumnVisibility;
import com.mware.ge.security.SecurityAuthorizations;
import com.mware.ge.security.VisibilityEvaluator;
import com.mware.ge.security.VisibilityParseException;
import com.mware.ge.util.ArrayUtils;
import com.mware.ge.util.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Authorizations
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] authorizations;
    private Map<String, Boolean> canReadCache;

    public Authorizations(String ... authorizations) {
        this.authorizations = authorizations;
        this.canReadCache = new ConcurrentHashMap<String, Boolean>();
    }

    public String[] getAuthorizations() {
        return this.authorizations;
    }

    public boolean equals(Authorizations authorizations) {
        return ArrayUtils.intersectsAll(this.getAuthorizations(), authorizations.getAuthorizations());
    }

    public boolean contains(Authorizations authorizations) {
        return ArrayUtils.containsAll(this.getAuthorizations(), authorizations.getAuthorizations());
    }

    public String toString() {
        return Arrays.toString(this.authorizations);
    }

    public boolean canRead(Visibility visibility) {
        Preconditions.checkNotNull(visibility, "visibility is required");
        if (visibility.getVisibilityString().length() == 0) {
            return true;
        }
        this.canReadCache.computeIfAbsent(visibility.getVisibilityString(), key -> {
            VisibilityEvaluator visibilityEvaluator = new VisibilityEvaluator(new SecurityAuthorizations(this.getAuthorizations()));
            ColumnVisibility columnVisibility = new ColumnVisibility(visibility.getVisibilityString());
            try {
                return visibilityEvaluator.evaluate(columnVisibility);
            }
            catch (VisibilityParseException e) {
                throw new GeException("could not evaluate visibility " + visibility.getVisibilityString(), e);
            }
        });
        return this.canReadCache.get(visibility.getVisibilityString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authorizations that = (Authorizations)o;
        return ArrayUtils.intersectsAll(this.getAuthorizations(), that.getAuthorizations());
    }

    public int hashCode() {
        return Arrays.hashCode(this.authorizations);
    }
}

