/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.EdgeElementLocation;
import com.mware.ge.EdgeVertices;
import com.mware.ge.Element;
import com.mware.ge.ElementType;
import com.mware.ge.FetchHints;
import com.mware.ge.Vertex;
import com.mware.ge.mutation.ExistingEdgeMutation;
import com.mware.ge.util.IterableUtils;
import java.util.ArrayList;
import java.util.Map;

public interface Edge
extends Element,
EdgeElementLocation {
    public static final String LABEL_PROPERTY_NAME = "__edgeLabel";
    public static final String OUT_VERTEX_ID_PROPERTY_NAME = "__outVertexId";
    public static final String OUT_VERTEX_TYPE_PROPERTY_NAME = "__outVertexType";
    public static final String IN_VERTEX_ID_PROPERTY_NAME = "__inVertexId";
    public static final String IN_VERTEX_TYPE_PROPERTY_NAME = "__inVertexType";
    public static final String IN_OR_OUT_VERTEX_ID_PROPERTY_NAME = "__inOrOutVertexId";

    @Override
    public String getLabel();

    @Override
    public String getVertexId(Direction var1);

    default public Vertex getVertex(Direction direction, Authorizations authorizations) {
        return this.getVertex(direction, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    default public String getVertexType(Direction direction, Authorizations authorizations) {
        Vertex v = this.getVertex(direction, FetchHints.NONE, authorizations);
        if (v != null) {
            return v.getConceptType();
        }
        return null;
    }

    default public Vertex getVertex(Direction direction, FetchHints fetchHints, Authorizations authorizations) {
        String vertexId = this.getVertexId(direction);
        return this.getGraph().getVertex(vertexId, fetchHints, authorizations);
    }

    public String getOtherVertexId(String var1);

    default public Vertex getOtherVertex(String myVertexId, Authorizations authorizations) {
        return this.getOtherVertex(myVertexId, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    default public Vertex getOtherVertex(String myVertexId, FetchHints fetchHints, Authorizations authorizations) {
        String vertexId = this.getOtherVertexId(myVertexId);
        return this.getGraph().getVertex(vertexId, fetchHints, authorizations);
    }

    default public EdgeVertices getVertices(Authorizations authorizations) {
        return this.getVertices(this.getGraph().getDefaultFetchHints(), authorizations);
    }

    default public EdgeVertices getVertices(FetchHints fetchHints, Authorizations authorizations) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.getVertexId(Direction.OUT));
        ids.add(this.getVertexId(Direction.IN));
        Map<String, Vertex> vertices = IterableUtils.toMapById(this.getGraph().getVertices(ids, fetchHints, authorizations));
        return new EdgeVertices(vertices.get(this.getVertexId(Direction.OUT)), vertices.get(this.getVertexId(Direction.IN)));
    }

    public ExistingEdgeMutation prepareMutation();

    @Override
    default public ElementType getElementType() {
        return ElementType.EDGE;
    }
}

