/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.ElementBuilder;
import com.mware.ge.ElementType;
import com.mware.ge.GeException;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.EdgeMutation;
import com.mware.ge.util.IncreasingTime;

public abstract class EdgeBuilderBase
extends ElementBuilder<Edge>
implements EdgeMutation {
    private String outVertexId;
    private String inVertexId;
    private String label;
    private String newEdgeLabel;
    private long alterEdgeLabelTimestamp;

    protected EdgeBuilderBase(String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility) {
        super(ElementType.EDGE, edgeId, visibility);
        this.outVertexId = outVertexId;
        this.inVertexId = inVertexId;
        this.label = label;
        this.alterEdgeLabelTimestamp = IncreasingTime.currentTimeMillis();
    }

    @Override
    public String getVertexId(Direction direction) {
        switch (direction) {
            case OUT: {
                return this.outVertexId;
            }
            case IN: {
                return this.inVertexId;
            }
        }
        throw new GeException("unhandled direction: " + (Object)((Object)direction));
    }

    @Override
    public String getEdgeLabel() {
        return this.label;
    }

    @Override
    public long getAlterEdgeLabelTimestamp() {
        return this.alterEdgeLabelTimestamp;
    }

    @Override
    public EdgeMutation alterEdgeLabel(String newEdgeLabel) {
        this.newEdgeLabel = newEdgeLabel;
        return this;
    }

    public EdgeBuilderBase overrideAlterLabelTimestamp(long alterEdgeLabelTimestamp) {
        this.alterEdgeLabelTimestamp = alterEdgeLabelTimestamp;
        return this;
    }

    @Override
    public String getNewEdgeLabel() {
        return this.newEdgeLabel;
    }

    @Override
    public abstract Edge save(Authorizations var1);

    @Override
    public boolean hasChanges() {
        if (this.newEdgeLabel != null) {
            return true;
        }
        return super.hasChanges();
    }

    public void setInVertexId(String inVertexId) {
        this.inVertexId = inVertexId;
    }

    public void setOutVertexId(String outVertexId) {
        this.outVertexId = outVertexId;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

