/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.EdgeInfo;
import com.mware.ge.FetchHints;
import com.mware.ge.Graph;
import com.mware.ge.GraphElementContainer;
import com.mware.ge.Vertex;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.LookAheadIterable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class EdgeVertexPair
implements GraphElementContainer {
    private final Edge edge;
    private final Vertex vertex;

    public EdgeVertexPair(Edge edge, Vertex vertex) {
        this.edge = edge;
        this.vertex = vertex;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public String toString() {
        return "EdgeVertexPair{edge=" + this.edge + ", vertex=" + this.vertex + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgeVertexPair that = (EdgeVertexPair)o;
        if (!this.edge.equals(that.edge)) {
            return false;
        }
        return this.vertex.equals(that.vertex);
    }

    public int hashCode() {
        int result = this.edge.hashCode();
        result = 31 * result + this.vertex.hashCode();
        return result;
    }

    public static Iterable<EdgeVertexPair> getEdgeVertexPairs(final Graph graph, final String sourceVertexId, Iterable<EdgeInfo> edgeInfos, final FetchHints fetchHints, final Long endTime, final Authorizations authorizations) {
        final HashSet<String> edgeIdsToFetch = new HashSet<String>();
        HashSet<String> vertexIdsToFetch = new HashSet<String>();
        for (EdgeInfo edgeInfo : edgeInfos) {
            edgeIdsToFetch.add(edgeInfo.getEdgeId());
            vertexIdsToFetch.add(edgeInfo.getVertexId());
        }
        final Map<String, Vertex> vertices = IterableUtils.toMapById(graph.getVertices(vertexIdsToFetch, fetchHints, endTime, authorizations));
        return new LookAheadIterable<Edge, EdgeVertexPair>(){

            @Override
            protected boolean isIncluded(Edge edge, EdgeVertexPair edgeVertexPair) {
                String otherVertexId = edge.getOtherVertexId(sourceVertexId);
                return vertices.get(otherVertexId) != null;
            }

            @Override
            protected EdgeVertexPair convert(Edge edge) {
                String otherVertexId = edge.getOtherVertexId(sourceVertexId);
                Vertex otherVertex = (Vertex)vertices.get(otherVertexId);
                return new EdgeVertexPair(edge, otherVertex);
            }

            @Override
            protected Iterator<Edge> createIterator() {
                return graph.getEdges(edgeIdsToFetch, fetchHints, endTime, authorizations).iterator();
            }
        };
    }
}

