/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mware.ge.Direction;
import com.mware.ge.GeException;
import java.util.HashMap;
import java.util.Map;

public class EdgesSummary {
    private ImmutableMap<String, Integer> outEdgeCountsByLabels;
    private ImmutableMap<String, Integer> inEdgeCountsByLabels;

    public EdgesSummary(ImmutableMap<String, Integer> outEdgeCountsByLabels, ImmutableMap<String, Integer> inEdgeCountsByLabels) {
        this.outEdgeCountsByLabels = outEdgeCountsByLabels;
        this.inEdgeCountsByLabels = inEdgeCountsByLabels;
    }

    public EdgesSummary(Map<String, Integer> outEdgeCountsByLabels, Map<String, Integer> inEdgeCountsByLabels) {
        this((ImmutableMap<String, Integer>)ImmutableMap.copyOf(outEdgeCountsByLabels), (ImmutableMap<String, Integer>)ImmutableMap.copyOf(inEdgeCountsByLabels));
    }

    public ImmutableMap<String, Integer> getOutEdgeCountsByLabels() {
        return this.outEdgeCountsByLabels;
    }

    public ImmutableMap<String, Integer> getInEdgeCountsByLabels() {
        return this.inEdgeCountsByLabels;
    }

    public ImmutableMap<String, Integer> getEdgeCountsByLabels() {
        HashMap<String, Integer> m = new HashMap<String, Integer>((Map<String, Integer>)this.getOutEdgeCountsByLabels());
        for (Map.Entry entry : this.getInEdgeCountsByLabels().entrySet()) {
            m.merge((String)entry.getKey(), (Integer)entry.getValue(), (a, b) -> a + b);
        }
        return ImmutableMap.copyOf(m);
    }

    public ImmutableSet<String> getOutEdgeLabels() {
        return this.outEdgeCountsByLabels.keySet();
    }

    public ImmutableSet<String> getInEdgeLabels() {
        return this.inEdgeCountsByLabels.keySet();
    }

    public ImmutableSet<String> getEdgeLabels() {
        return ImmutableSet.builder().addAll(this.getOutEdgeLabels()).addAll(this.getInEdgeLabels()).build();
    }

    public ImmutableSet<String> getEdgeLabels(Direction direction) {
        if (direction == Direction.IN) {
            return this.getInEdgeLabels();
        }
        if (direction == Direction.OUT) {
            return this.getOutEdgeLabels();
        }
        if (direction == Direction.BOTH) {
            return this.getEdgeLabels();
        }
        throw new GeException("Unsupported direction: " + (Object)((Object)direction));
    }

    public int getCountOfOutEdges() {
        return this.outEdgeCountsByLabels.values().stream().mapToInt(l -> l).sum();
    }

    public int getCountOfInEdges() {
        return this.inEdgeCountsByLabels.values().stream().mapToInt(l -> l).sum();
    }

    public int getCountOfEdges() {
        return this.getCountOfOutEdges() + this.getCountOfInEdges();
    }

    public int getCountOfEdges(Direction direction) {
        if (direction == Direction.IN) {
            return this.getCountOfInEdges();
        }
        if (direction == Direction.OUT) {
            return this.getCountOfOutEdges();
        }
        if (direction == Direction.BOTH) {
            return this.getCountOfEdges();
        }
        throw new GeException("Unsupported direction: " + (Object)((Object)direction));
    }
}

