/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.google.common.collect.ImmutableSet;
import com.mware.ge.Authorizations;
import com.mware.ge.ElementLocation;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.FetchHints;
import com.mware.ge.GeObject;
import com.mware.ge.Graph;
import com.mware.ge.HistoricalPropertyValue;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.query.QueryableIterable;
import com.mware.ge.util.FilterIterable;
import com.mware.ge.values.storable.Value;

public interface Element
extends GeObject,
ElementLocation {
    public static final String ID_PROPERTY_NAME = "__ID__";

    @Override
    public Visibility getVisibility();

    public long getTimestamp();

    default public Long getEndTime() {
        return null;
    }

    default public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(Authorizations authorizations) {
        return this.getHistoricalPropertyValues(null, null, authorizations);
    }

    default public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(Long startTime, Long endTime, Authorizations authorizations) {
        return this.getHistoricalPropertyValues(null, null, null, startTime, endTime, authorizations);
    }

    default public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(String key, String name, Visibility visibility, Authorizations authorizations) {
        return this.getHistoricalPropertyValues(key, name, visibility, null, null, authorizations);
    }

    default public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(String key, String name, Visibility visibility, final Long startTime, final Long endTime, Authorizations authorizations) {
        return new FilterIterable<HistoricalPropertyValue>(this.getHistoricalPropertyValues(key, name, visibility, authorizations)){

            @Override
            protected boolean isIncluded(HistoricalPropertyValue pv) {
                if (startTime != null && pv.getTimestamp() < startTime) {
                    return false;
                }
                return endTime == null || pv.getTimestamp() <= endTime;
            }
        };
    }

    public <T extends Element> ExistingElementMutation<T> prepareMutation();

    default public void deleteProperty(Property property, Authorizations authorizations) {
        this.deleteProperty(property.getKey(), property.getName(), property.getVisibility(), authorizations);
    }

    default public void deleteProperty(String key, String name, Authorizations authorizations) {
        this.deleteProperty(key, name, null, authorizations);
    }

    public void deleteProperty(String var1, String var2, Visibility var3, Authorizations var4);

    default public void deleteProperties(String name, Authorizations authorizations) {
        for (Property p : this.getProperties(name)) {
            this.deleteProperty(p.getKey(), p.getName(), p.getVisibility(), authorizations);
        }
    }

    default public void softDeleteProperty(String key, String name, Authorizations authorizations) {
        this.softDeleteProperty(key, name, null, authorizations);
    }

    public void softDeleteProperty(String var1, String var2, Visibility var3, Authorizations var4);

    default public void softDeleteProperties(String name, Authorizations authorizations) {
        for (Property property : this.getProperties(name)) {
            this.softDeleteProperty(property.getKey(), property.getName(), property.getVisibility(), authorizations);
        }
    }

    public Graph getGraph();

    default public void addPropertyValue(String key, String name, Value value, Visibility visibility, Authorizations authorizations) {
        this.prepareMutation().addPropertyValue(key, name, value, visibility).save(authorizations);
    }

    default public void addPropertyValue(String key, String name, Value value, Metadata metadata, Visibility visibility, Authorizations authorizations) {
        this.prepareMutation().addPropertyValue(key, name, value, metadata, visibility).save(authorizations);
    }

    default public void setProperty(String name, Value value, Visibility visibility, Authorizations authorizations) {
        this.prepareMutation().setProperty(name, value, visibility).save(authorizations);
    }

    default public void setProperty(String name, Value value, Metadata metadata, Visibility visibility, Authorizations authorizations) {
        this.prepareMutation().setProperty(name, value, metadata, visibility).save(authorizations);
    }

    public Authorizations getAuthorizations();

    default public void markPropertyHidden(String key, String name, Visibility propertyVisibility, Visibility visibility, Authorizations authorizations) {
        this.markPropertyHidden(key, name, propertyVisibility, null, visibility, authorizations);
    }

    default public void markPropertyHidden(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Iterable<Property> properties = this.getProperties(key, name);
        for (Property property : properties) {
            if (!property.getVisibility().equals(propertyVisibility)) continue;
            this.markPropertyHidden(property, timestamp, visibility, authorizations);
            return;
        }
        throw new IllegalArgumentException("Could not find property " + key + " : " + name + " : " + propertyVisibility);
    }

    default public void markPropertyHidden(Property property, Visibility visibility, Authorizations authorizations) {
        this.markPropertyHidden(property, null, visibility, authorizations);
    }

    public void markPropertyHidden(Property var1, Long var2, Visibility var3, Authorizations var4);

    default public void markPropertyVisible(String key, String name, Visibility propertyVisibility, Visibility visibility, Authorizations authorizations) {
        this.markPropertyVisible(key, name, propertyVisibility, null, visibility, authorizations);
    }

    default public void markPropertyVisible(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Iterable<Property> properties = this.getProperties(key, name);
        for (Property property : properties) {
            if (!property.getVisibility().equals(propertyVisibility)) continue;
            this.markPropertyVisible(property, timestamp, visibility, authorizations);
            return;
        }
        throw new IllegalArgumentException("Could not find property " + key + " : " + name + " : " + propertyVisibility);
    }

    default public void markPropertyVisible(Property property, Visibility visibility, Authorizations authorizations) {
        this.markPropertyVisible(property, null, visibility, authorizations);
    }

    public void markPropertyVisible(Property var1, Long var2, Visibility var3, Authorizations var4);

    default public boolean isHidden(Authorizations authorizations) {
        for (Visibility visibility : this.getHiddenVisibilities()) {
            if (!authorizations.canRead(visibility)) continue;
            return true;
        }
        return false;
    }

    public Iterable<Visibility> getHiddenVisibilities();

    public ImmutableSet<String> getExtendedDataTableNames();

    default public QueryableIterable<ExtendedDataRow> getExtendedData(String tableName) {
        return this.getExtendedData(tableName, this.getFetchHints());
    }

    public QueryableIterable<ExtendedDataRow> getExtendedData(String var1, FetchHints var2);

    default public QueryableIterable<ExtendedDataRow> getExtendedData() {
        return this.getExtendedData(this.getFetchHints());
    }

    default public QueryableIterable<ExtendedDataRow> getExtendedData(FetchHints fetchHints) {
        return this.getExtendedData(null, fetchHints);
    }

    public FetchHints getFetchHints();

    default public int compareTo(Object o) {
        if (this.getClass().isInstance(o)) {
            return ((String)this.getId()).compareTo((String)((Element)o).getId());
        }
        throw new ClassCastException("o must be an " + this.getClass().getName());
    }
}

