/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ElementId;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.property.MutablePropertyImpl;
import com.mware.ge.util.FilterIterable;
import com.mware.ge.values.storable.EdgeVertexIds;
import com.mware.ge.values.storable.Values;
import java.util.ArrayList;

public abstract class ElementBase
implements Element {
    private transient Property idProperty;
    private transient Property edgeLabelProperty;
    private transient Property outVertexIdProperty;
    private transient Property inVertexIdProperty;
    private transient Property inOrOutVertexIdProperty;
    private transient Property tableNameProperty;
    private transient Property rowIdProperty;
    private transient Property elementTypeProperty;
    private transient Property elementIdProperty;

    @Override
    public Property getProperty(String key, String name, Visibility visibility) {
        Property reservedProperty = this.getReservedProperty(name);
        if (reservedProperty != null) {
            return reservedProperty;
        }
        for (Property p : this.internalGetProperties(key, name)) {
            if (visibility == null) {
                return p;
            }
            if (!visibility.equals(p.getVisibility())) continue;
            return p;
        }
        return null;
    }

    protected Property getReservedProperty(String name) {
        if ("__ID__".equals(name)) {
            return this.getIdProperty();
        }
        if ("__edgeLabel".equals(name) && this instanceof Edge) {
            return this.getEdgeLabelProperty();
        }
        if ("__outVertexId".equals(name) && this instanceof Edge) {
            return this.getOutVertexIdProperty();
        }
        if ("__inVertexId".equals(name) && this instanceof Edge) {
            return this.getInVertexIdProperty();
        }
        if ("__inOrOutVertexId".equals(name) && this instanceof Edge) {
            return this.getInOrOutVertexIdProperty();
        }
        if ("__extendedDataTableName".equals(name) && this instanceof ExtendedDataRow) {
            return this.getTableNameProperty();
        }
        if ("__extendedDataRowId".equals(name) && this instanceof ExtendedDataRow) {
            return this.getRowIdProperty();
        }
        if ("__extendedDataElementId".equals(name) && this instanceof ExtendedDataRow) {
            return this.getElementIdProperty();
        }
        if ("__extendedDataElementType".equals(name) && this instanceof ExtendedDataRow) {
            return this.getElementTypeProperty();
        }
        return null;
    }

    @Override
    public Property getProperty(String name, Visibility visibility) {
        return this.getProperty("", name, visibility);
    }

    @Override
    public Iterable<Property> getProperties(String name) {
        return this.getProperties(null, name);
    }

    protected Iterable<Property> internalGetProperties(final String key, final String name) {
        this.getFetchHints().assertPropertyIncluded(name);
        return new FilterIterable<Property>(this.getProperties()){

            @Override
            protected boolean isIncluded(Property property) {
                if (key != null && !property.getKey().equals(key)) {
                    return false;
                }
                return property.getName().equals(name);
            }
        };
    }

    @Override
    public Iterable<Property> getProperties(String key, String name) {
        Property reservedProperty = this.getReservedProperty(name);
        if (reservedProperty != null) {
            ArrayList<Property> result = new ArrayList<Property>();
            result.add(reservedProperty);
            return result;
        }
        this.getFetchHints().assertPropertyIncluded(name);
        return this.internalGetProperties(key, name);
    }

    protected Property getIdProperty() {
        if (this.idProperty == null) {
            this.idProperty = new MutablePropertyImpl("", "__ID__", Values.stringValue((String)this.getId()), null, this.getTimestamp(), null, null, this.getFetchHints());
        }
        return this.idProperty;
    }

    protected Property getEdgeLabelProperty() {
        if (this.edgeLabelProperty == null && this instanceof Edge) {
            String edgeLabel = ((Edge)((Object)this)).getLabel();
            this.edgeLabelProperty = new MutablePropertyImpl("", "__edgeLabel", Values.stringValue(edgeLabel), null, this.getTimestamp(), null, null, this.getFetchHints());
        }
        return this.edgeLabelProperty;
    }

    protected Property getOutVertexIdProperty() {
        if (this.outVertexIdProperty == null && this instanceof Edge) {
            String outVertexId = ((Edge)((Object)this)).getVertexId(Direction.OUT);
            this.outVertexIdProperty = new MutablePropertyImpl("", "__outVertexId", Values.stringValue(outVertexId), null, this.getTimestamp(), null, null, this.getFetchHints());
        }
        return this.outVertexIdProperty;
    }

    protected Property getInVertexIdProperty() {
        if (this.inVertexIdProperty == null && this instanceof Edge) {
            String inVertexId = ((Edge)((Object)this)).getVertexId(Direction.IN);
            this.inVertexIdProperty = new MutablePropertyImpl("", "__inVertexId", Values.stringValue(inVertexId), null, this.getTimestamp(), null, null, this.getFetchHints());
        }
        return this.inVertexIdProperty;
    }

    protected Property getInOrOutVertexIdProperty() {
        if (this.inOrOutVertexIdProperty == null && this instanceof Edge) {
            String inVertexId = ((Edge)((Object)this)).getVertexId(Direction.IN);
            String outVertexId = ((Edge)((Object)this)).getVertexId(Direction.OUT);
            this.inOrOutVertexIdProperty = new MutablePropertyImpl("", "__inOrOutVertexId", new EdgeVertexIds(outVertexId, inVertexId), null, this.getTimestamp(), null, null, this.getFetchHints());
        }
        return this.inOrOutVertexIdProperty;
    }

    protected Property getTableNameProperty() {
        if (this.tableNameProperty == null && this instanceof ExtendedDataRow) {
            String tableName = ((ExtendedDataRow)((Object)this)).getId().getTableName();
            this.tableNameProperty = new MutablePropertyImpl("", "__extendedDataTableName", Values.stringValue(tableName), null, this.getTimestamp(), null, null, this.getFetchHints());
        }
        return this.tableNameProperty;
    }

    protected Property getRowIdProperty() {
        if (this.rowIdProperty == null && this instanceof ExtendedDataRow) {
            String rowId = ((ExtendedDataRow)((Object)this)).getId().getRowId();
            this.rowIdProperty = new MutablePropertyImpl("", "__extendedDataRowId", Values.stringValue(rowId), null, this.getTimestamp(), null, null, this.getFetchHints());
        }
        return this.rowIdProperty;
    }

    protected Property getElementTypeProperty() {
        if (this.elementTypeProperty == null && this instanceof ExtendedDataRow) {
            String elementType = ((ExtendedDataRow)((Object)this)).getId().getElementType().name();
            this.elementTypeProperty = new MutablePropertyImpl("", "__extendedDataElementType", Values.stringValue(elementType), null, this.getTimestamp(), null, null, this.getFetchHints());
        }
        return this.elementTypeProperty;
    }

    protected Property getElementIdProperty() {
        if (this.elementIdProperty == null && this instanceof ExtendedDataRow) {
            String elementId = ((ExtendedDataRow)((Object)this)).getId().getElementId();
            this.elementIdProperty = new MutablePropertyImpl("", "__extendedDataElementId", Values.stringValue(elementId), null, this.getTimestamp(), null, null, this.getFetchHints());
        }
        return this.elementIdProperty;
    }

    public int hashCode() {
        return ((String)this.getId()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElementId) {
            ElementId objElementId = (ElementId)obj;
            return ((String)this.getId()).equals(objElementId.getId()) && this.getElementType().equals((Object)objElementId.getElementType());
        }
        return super.equals(obj);
    }

    public String toString() {
        if (this instanceof Edge) {
            Edge edge = (Edge)((Object)this);
            return (String)this.getId() + ":[" + edge.getVertexId(Direction.OUT) + "-" + edge.getLabel() + "->" + edge.getVertexId(Direction.IN) + "]";
        }
        if (this instanceof Vertex) {
            Vertex vertex = (Vertex)((Object)this);
            return "(" + (String)this.getId() + ":" + vertex.getConceptType() + ")";
        }
        return this.getId();
    }
}

