/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.google.common.collect.ImmutableSet;
import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.ElementType;
import com.mware.ge.FetchHints;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ElementMutation;
import com.mware.ge.mutation.ExtendedDataDeleteMutation;
import com.mware.ge.mutation.ExtendedDataMutation;
import com.mware.ge.mutation.ExtendedDataMutationBase;
import com.mware.ge.mutation.KeyNameVisibilityPropertyDeleteMutation;
import com.mware.ge.mutation.KeyNameVisibilityPropertySoftDeleteMutation;
import com.mware.ge.mutation.PropertyDeleteMutation;
import com.mware.ge.mutation.PropertyPropertyDeleteMutation;
import com.mware.ge.mutation.PropertyPropertySoftDeleteMutation;
import com.mware.ge.mutation.PropertySoftDeleteMutation;
import com.mware.ge.property.MutablePropertyImpl;
import com.mware.ge.search.IndexHint;
import com.mware.ge.util.IncreasingTime;
import com.mware.ge.util.Preconditions;
import com.mware.ge.util.StreamUtils;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.List;

public abstract class ElementBuilder<T extends Element>
implements ElementMutation<T> {
    protected final List<Property> properties = new ArrayList<Property>();
    protected final List<PropertyDeleteMutation> propertyDeletes = new ArrayList<PropertyDeleteMutation>();
    protected final List<PropertySoftDeleteMutation> propertySoftDeletes = new ArrayList<PropertySoftDeleteMutation>();
    protected final List<ExtendedDataMutation> extendedDatas = new ArrayList<ExtendedDataMutation>();
    protected final List<ExtendedDataDeleteMutation> extendedDataDeletes = new ArrayList<ExtendedDataDeleteMutation>();
    protected String elementId;
    protected final ElementType elementType;
    private final Visibility elementVisibility;
    protected IndexHint indexHint = IndexHint.INDEX;

    protected ElementBuilder(ElementType elementType, String elementId, Visibility elementVisibility) {
        this.elementType = elementType;
        this.elementId = elementId;
        this.elementVisibility = elementVisibility;
    }

    @Override
    public String getId() {
        return this.elementId;
    }

    @Override
    public ElementBuilder<T> setProperty(String name, Value value, Visibility visibility) {
        return this.setProperty(name, value, Metadata.create(FetchHints.ALL), visibility);
    }

    @Override
    public ElementBuilder<T> setProperty(String name, Value value, Metadata metadata, Visibility visibility) {
        return this.addPropertyValue("", name, value, metadata, visibility);
    }

    @Override
    public ElementBuilder<T> addPropertyValue(String key, String name, Value value, Visibility visibility) {
        return this.addPropertyValue(key, name, value, Metadata.create(FetchHints.ALL), visibility);
    }

    @Override
    public ElementBuilder<T> addPropertyValue(String key, String name, Value value, Metadata metadata, Visibility visibility) {
        return this.addPropertyValue(key, name, value, metadata, IncreasingTime.currentTimeMillis(), visibility);
    }

    @Override
    public ElementBuilder<T> addPropertyValue(String key, String name, Value value, Metadata metadata, Long timestamp, Visibility visibility) {
        if (name == null) {
            throw new NullPointerException("property name cannot be null for property: " + name + ":" + key);
        }
        if (value == null) {
            throw new NullPointerException("property value cannot be null for property: " + name + ":" + key);
        }
        this.properties.add(new MutablePropertyImpl(key, name, value, metadata, timestamp, null, visibility, FetchHints.ALL_INCLUDING_HIDDEN));
        return this;
    }

    @Override
    public ElementBuilder<T> deleteProperty(Property property) {
        this.propertyDeletes.add(new PropertyPropertyDeleteMutation(property));
        return this;
    }

    @Override
    public ElementBuilder<T> deleteProperty(String name, Visibility visibility) {
        return this.deleteProperty("", name, visibility);
    }

    @Override
    public ElementBuilder<T> deleteProperty(String key, String name, Visibility visibility) {
        Preconditions.checkNotNull(name, "property name cannot be null for property: " + name + ":" + key);
        this.propertyDeletes.add(new KeyNameVisibilityPropertyDeleteMutation(key, name, visibility));
        return this;
    }

    @Override
    public ElementBuilder<T> softDeleteProperty(Property property) {
        this.propertySoftDeletes.add(new PropertyPropertySoftDeleteMutation(property));
        return this;
    }

    @Override
    public ElementBuilder<T> softDeleteProperty(String name, Visibility visibility) {
        return this.softDeleteProperty("", name, visibility);
    }

    @Override
    public ElementBuilder<T> softDeleteProperty(String key, String name, Visibility visibility) {
        Preconditions.checkNotNull(name, "property name cannot be null for property: " + name + ":" + key);
        this.propertySoftDeletes.add(new KeyNameVisibilityPropertySoftDeleteMutation(key, name, visibility));
        return this;
    }

    @Override
    public ElementBuilder<T> addExtendedData(String tableName, String row, String column, Value value, Visibility visibility) {
        return this.addExtendedData(tableName, row, column, null, value, visibility);
    }

    @Override
    public ElementMutation<T> addExtendedData(String tableName, String row, String column, Value value, Long timestamp, Visibility visibility) {
        return this.addExtendedData(tableName, row, column, null, value, timestamp, visibility);
    }

    @Override
    public ElementBuilder<T> addExtendedData(String tableName, String row, String column, String key, Value value, Visibility visibility) {
        return this.addExtendedData(tableName, row, column, key, value, IncreasingTime.currentTimeMillis(), visibility);
    }

    @Override
    public ElementBuilder<T> addExtendedData(String tableName, String row, String column, String key, Value value, Long timestamp, Visibility visibility) {
        this.extendedDatas.add(new ExtendedDataMutation(tableName, row, column, key, value, timestamp, visibility));
        return this;
    }

    @Override
    public ElementBuilder<T> deleteExtendedData(String tableName, String row, String column, Visibility visibility) {
        return this.deleteExtendedData(tableName, row, column, null, visibility);
    }

    @Override
    public ElementMutation<T> deleteExtendedData(String tableName, String row) {
        return this.deleteExtendedData(tableName, row, null, null);
    }

    @Override
    public ElementMutation<T> deleteExtendedDataTable(String tableName) {
        return this.deleteExtendedData(tableName, null, null, null);
    }

    @Override
    public ElementBuilder<T> deleteExtendedData(String tableName, String row, String column, String key, Visibility visibility) {
        this.extendedDataDeletes.add(new ExtendedDataDeleteMutation(tableName, row, column, key, visibility));
        return this;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public Visibility getVisibility() {
        return this.elementVisibility;
    }

    @Override
    public abstract T save(Authorizations var1);

    @Override
    public Iterable<Property> getProperties() {
        return this.properties;
    }

    @Override
    public Iterable<PropertyDeleteMutation> getPropertyDeletes() {
        return this.propertyDeletes;
    }

    @Override
    public Iterable<PropertySoftDeleteMutation> getPropertySoftDeletes() {
        return this.propertySoftDeletes;
    }

    @Override
    public Iterable<ExtendedDataMutation> getExtendedData() {
        return this.extendedDatas;
    }

    @Override
    public Iterable<ExtendedDataDeleteMutation> getExtendedDataDeletes() {
        return this.extendedDataDeletes;
    }

    @Override
    public IndexHint getIndexHint() {
        return this.indexHint;
    }

    public ImmutableSet<String> getExtendedDataTableNames() {
        return this.extendedDatas.stream().map(ExtendedDataMutationBase::getTableName).collect(StreamUtils.toImmutableSet());
    }

    public ElementBuilder<T> overrideProperties(List<Property> properties) {
        this.properties.clear();
        this.properties.addAll(properties);
        return this;
    }

    public ElementBuilder<T> overridePropertyDeletes(List<PropertyDeleteMutation> propertyDeletes) {
        this.propertyDeletes.clear();
        this.propertyDeletes.addAll(propertyDeletes);
        return this;
    }

    public ElementBuilder<T> overridePropertySoftDeletes(List<PropertySoftDeleteMutation> propertySoftDeletes) {
        this.propertySoftDeletes.clear();
        this.propertySoftDeletes.addAll(propertySoftDeletes);
        return this;
    }

    public ElementBuilder<T> overrideExtendedDatas(List<ExtendedDataMutation> extendedDatas) {
        this.extendedDatas.clear();
        this.extendedDatas.addAll(extendedDatas);
        return this;
    }

    public ElementBuilder<T> overrideExtendedDataDeletes(List<ExtendedDataDeleteMutation> extendedDataDeletes) {
        this.extendedDataDeletes.clear();
        this.extendedDataDeletes.addAll(extendedDataDeletes);
        return this;
    }

    public ElementBuilder<T> overrideIndexHint(IndexHint indexHint) {
        this.indexHint = indexHint;
        return this;
    }

    @Override
    public ElementMutation<T> setIndexHint(IndexHint indexHint) {
        this.indexHint = indexHint;
        return this;
    }

    @Override
    public boolean hasChanges() {
        if (this.properties.size() > 0) {
            return true;
        }
        if (this.propertyDeletes.size() > 0) {
            return true;
        }
        if (this.propertySoftDeletes.size() > 0) {
            return true;
        }
        if (this.extendedDatas.size() > 0) {
            return true;
        }
        return this.extendedDataDeletes.size() > 0;
    }

    public void setId(String id) {
        this.elementId = id;
    }
}

