/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.google.common.collect.Lists;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.property.MutablePropertyImpl;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.FilterIterable;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.util.Iterator;

public abstract class ExtendedDataRowBase
implements ExtendedDataRow {
    private final FetchHints fetchHints;
    private transient Property rowIdProperty;
    private transient Property tableNameProperty;
    private transient Property elementIdProperty;
    private transient Property elementTypeProperty;

    protected ExtendedDataRowBase(FetchHints fetchHints) {
        this.fetchHints = fetchHints;
    }

    @Override
    public abstract ExtendedDataRowId getId();

    @Override
    public Iterable<String> getPropertyNames() {
        return new ConvertingIterable<Property, String>(this.getProperties()){

            @Override
            protected String convert(Property prop) {
                return prop.getName();
            }
        };
    }

    @Override
    public abstract Iterable<Property> getProperties();

    @Override
    public Property getProperty(String name) {
        return this.getProperty(null, name, null);
    }

    @Override
    public Value getPropertyValue(String name) {
        return this.getPropertyValue(null, name);
    }

    @Override
    public Property getProperty(String key, String name, Visibility visibility) {
        if ("__extendedDataRowId".equals(name)) {
            return this.getRowIdProperty();
        }
        if ("__extendedDataTableName".equals(name)) {
            return this.getTableNameProperty();
        }
        if ("__extendedDataElementId".equals(name)) {
            return this.getElementIdProperty();
        }
        if ("__extendedDataElementType".equals(name)) {
            return this.getElementTypeProperty();
        }
        this.getFetchHints().assertPropertyIncluded(name);
        for (Property property : this.getProperties()) {
            if (!this.isMatch(property, key, name, visibility)) continue;
            return property;
        }
        return null;
    }

    private boolean isMatch(Property property, String key, String name, Visibility visibility) {
        if (name != null && !property.getName().equals(name)) {
            return false;
        }
        if (key != null && !property.getKey().equals(key)) {
            return false;
        }
        return visibility == null || property.getVisibility().equals(visibility);
    }

    @Override
    public Property getProperty(String name, Visibility visibility) {
        return this.getProperty(null, name, visibility);
    }

    @Override
    public Iterable<Property> getProperties(String name) {
        return this.getProperties(null, name);
    }

    @Override
    public Iterable<Property> getProperties(final String key, final String name) {
        if ("__extendedDataRowId".equals(name)) {
            return Lists.newArrayList((Object[])new Property[]{this.getRowIdProperty()});
        }
        if ("__extendedDataTableName".equals(name)) {
            return Lists.newArrayList((Object[])new Property[]{this.getTableNameProperty()});
        }
        if ("__extendedDataElementId".equals(name)) {
            return Lists.newArrayList((Object[])new Property[]{this.getElementIdProperty()});
        }
        if ("__extendedDataElementType".equals(name)) {
            return Lists.newArrayList((Object[])new Property[]{this.getElementTypeProperty()});
        }
        this.getFetchHints().assertPropertyIncluded(name);
        return new FilterIterable<Property>(this.getProperties()){

            @Override
            protected boolean isIncluded(Property prop) {
                return ExtendedDataRowBase.this.isMatch(prop, key, name, null);
            }
        };
    }

    @Override
    public Value getPropertyValue(String key, String name) {
        Property prop = this.getProperty(key, name);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    @Override
    public Value getPropertyValue(String name, int index) {
        return this.getPropertyValue(null, name, index);
    }

    @Override
    public Value getPropertyValue(String key, String name, int index) {
        if ("__extendedDataRowId".equals(name)) {
            return this.getRowIdProperty().getValue();
        }
        if ("__extendedDataTableName".equals(name)) {
            return this.getTableNameProperty().getValue();
        }
        if ("__extendedDataElementId".equals(name)) {
            return this.getElementIdProperty().getValue();
        }
        if ("__extendedDataElementType".equals(name)) {
            return this.getElementTypeProperty().getValue();
        }
        Iterator<Value> values = this.getPropertyValues(key, name).iterator();
        while (values.hasNext() && index > 0) {
            values.next();
            --index;
        }
        if (!values.hasNext()) {
            return null;
        }
        return values.next();
    }

    public int compareTo(Object o) {
        if (o instanceof ExtendedDataRow) {
            return this.getId().compareTo(((ExtendedDataRow)o).getId());
        }
        throw new ClassCastException("o must be an " + ExtendedDataRow.class.getName());
    }

    protected Property getRowIdProperty() {
        if (this.rowIdProperty == null) {
            this.rowIdProperty = new MutablePropertyImpl("", "__extendedDataRowId", Values.stringValue(this.getId().getRowId()), null, null, null, null, FetchHints.ALL);
        }
        return this.rowIdProperty;
    }

    protected Property getTableNameProperty() {
        if (this.tableNameProperty == null) {
            this.tableNameProperty = new MutablePropertyImpl("", "__extendedDataTableName", Values.stringValue(this.getId().getTableName()), null, null, null, null, FetchHints.ALL);
        }
        return this.tableNameProperty;
    }

    protected Property getElementIdProperty() {
        if (this.elementIdProperty == null) {
            this.elementIdProperty = new MutablePropertyImpl("", "__extendedDataElementId", Values.stringValue(this.getId().getElementId()), null, null, null, null, FetchHints.ALL);
        }
        return this.elementIdProperty;
    }

    protected Property getElementTypeProperty() {
        if (this.elementTypeProperty == null) {
            this.elementTypeProperty = new MutablePropertyImpl("", "__extendedDataElementType", Values.stringValue(this.getId().getElementType().name()), null, null, null, null, FetchHints.ALL);
        }
        return this.elementTypeProperty;
    }

    @Override
    public FetchHints getFetchHints() {
        return this.fetchHints;
    }
}

