/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.mware.ge.Direction;
import com.mware.ge.FetchHintsBuilder;
import com.mware.ge.GeException;
import com.mware.ge.GeMissingFetchHintException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

public class FetchHints
implements Serializable {
    private final boolean includeAllProperties;
    private final ImmutableSet<String> propertyNamesToInclude;
    private final boolean includeAllPropertyMetadata;
    private final ImmutableSet<String> metadataKeysToInclude;
    private final boolean includeHidden;
    private final boolean includeAllEdgeRefs;
    private final boolean includeOutEdgeRefs;
    private final boolean includeInEdgeRefs;
    private final boolean includeEdgeIds;
    private final boolean includeEdgeVertexIds;
    private final ImmutableSet<String> edgeLabelsOfEdgeRefsToInclude;
    private final boolean includeEdgeLabelsAndCounts;
    private final boolean includeExtendedDataTableNames;
    public static final FetchHints NONE = new FetchHintsBuilder().build();
    public static final FetchHints PROPERTIES = new FetchHintsBuilder().setIncludeAllProperties(true).build();
    public static final FetchHints PROPERTIES_AND_EDGE_REFS = new FetchHintsBuilder().setIncludeAllProperties(true).setIncludeAllPropertyMetadata(true).setIncludeExtendedDataTableNames(true).setIncludeAllEdgeRefs(true).build();
    public static final FetchHints PROPERTIES_AND_METADATA = new FetchHintsBuilder().setIncludeAllProperties(true).setIncludeAllPropertyMetadata(true).build();
    public static final FetchHints ALL = new FetchHintsBuilder().setIncludeAllProperties(true).setIncludeAllPropertyMetadata(true).setIncludeAllEdgeRefs(true).setIncludeExtendedDataTableNames(true).build();
    public static final FetchHints ALL_INCLUDING_HIDDEN = new FetchHintsBuilder().setIncludeAllProperties(true).setIncludeAllPropertyMetadata(true).setIncludeAllEdgeRefs(true).setIncludeExtendedDataTableNames(true).setIncludeHidden(true).build();
    public static final FetchHints EDGE_REFS = new FetchHintsBuilder().setIncludeAllEdgeRefs(true).build();
    public static final FetchHints EDGE_LABELS = new FetchHintsBuilder().setIncludeEdgeLabelsAndCounts(true).build();

    FetchHints(boolean includeAllProperties, ImmutableSet<String> propertyNamesToInclude, boolean includeAllPropertyMetadata, ImmutableSet<String> metadataKeysToInclude, boolean includeHidden, boolean includeAllEdgeRefs, boolean includeOutEdgeRefs, boolean includeInEdgeRefs, boolean includeEdgeIds, boolean includeEdgeVertexIds, ImmutableSet<String> edgeLabelsOfEdgeRefsToInclude, boolean includeEdgeLabelsAndCounts, boolean includeExtendedDataTableNames) {
        this.includeAllProperties = includeAllProperties;
        this.propertyNamesToInclude = propertyNamesToInclude;
        this.includeAllPropertyMetadata = includeAllPropertyMetadata;
        this.metadataKeysToInclude = metadataKeysToInclude;
        this.includeHidden = includeHidden;
        this.includeAllEdgeRefs = includeAllEdgeRefs;
        this.includeOutEdgeRefs = includeOutEdgeRefs;
        this.includeInEdgeRefs = includeInEdgeRefs;
        this.includeEdgeIds = includeEdgeIds;
        this.includeEdgeVertexIds = includeEdgeVertexIds;
        this.edgeLabelsOfEdgeRefsToInclude = includeAllEdgeRefs ? null : edgeLabelsOfEdgeRefsToInclude;
        this.includeEdgeLabelsAndCounts = includeEdgeLabelsAndCounts;
        this.includeExtendedDataTableNames = includeExtendedDataTableNames;
    }

    public static FetchHints copyAndMakeVisible(FetchHints fetchHints) {
        return new FetchHintsBuilder(fetchHints).setIncludeHidden(true).build();
    }

    public boolean isIncludeAllProperties() {
        return this.includeAllProperties;
    }

    public ImmutableSet<String> getPropertyNamesToInclude() {
        return this.propertyNamesToInclude;
    }

    public boolean isIncludeAllPropertyMetadata() {
        return this.includeAllPropertyMetadata;
    }

    public ImmutableSet<String> getMetadataKeysToInclude() {
        return this.metadataKeysToInclude;
    }

    public boolean isIncludeHidden() {
        return this.includeHidden;
    }

    public boolean isIncludeAllEdgeRefs() {
        return this.includeAllEdgeRefs;
    }

    public boolean isIncludeOutEdgeRefs() {
        return this.includeOutEdgeRefs;
    }

    public boolean isIncludeInEdgeRefs() {
        return this.includeInEdgeRefs;
    }

    public boolean isIncludeEdgeIds() {
        return this.includeEdgeIds;
    }

    public boolean isIncludeEdgeVertexIds() {
        return this.includeEdgeVertexIds;
    }

    public ImmutableSet<String> getEdgeLabelsOfEdgeRefsToInclude() {
        return this.edgeLabelsOfEdgeRefsToInclude;
    }

    public boolean isIncludeEdgeLabelsAndCounts() {
        return this.includeEdgeLabelsAndCounts;
    }

    public boolean isIncludeExtendedDataTableNames() {
        return this.includeExtendedDataTableNames;
    }

    public boolean isIncludePropertyMetadata() {
        return this.isIncludeAllPropertyMetadata() || this.getMetadataKeysToInclude() != null && this.getMetadataKeysToInclude().size() > 0;
    }

    public boolean isIncludeProperties() {
        return this.isIncludeAllProperties() || this.getPropertyNamesToInclude() != null && this.getPropertyNamesToInclude().size() > 0;
    }

    public boolean isIncludePropertyAndMetadata(String propertyName) {
        return this.isIncludeProperty(propertyName) && this.isIncludeAllPropertyMetadata();
    }

    public boolean isIncludeProperty(String propertyName) {
        if (this.isIncludeAllProperties()) {
            return true;
        }
        return this.getPropertyNamesToInclude() != null && this.getPropertyNamesToInclude().contains((Object)propertyName);
    }

    public boolean isIncludeMetadata(String metadataKey) {
        if (this.isIncludeAllPropertyMetadata()) {
            return true;
        }
        return this.getMetadataKeysToInclude() != null && this.getMetadataKeysToInclude().contains((Object)metadataKey);
    }

    public boolean isIncludeEdgeRefLabel(String label) {
        if (this.isIncludeAllEdgeRefs()) {
            return true;
        }
        if (this.getEdgeLabelsOfEdgeRefsToInclude() != null) {
            return this.getEdgeLabelsOfEdgeRefsToInclude().contains((Object)label);
        }
        return this.isIncludeOutEdgeRefs() || this.isIncludeInEdgeRefs();
    }

    public boolean isIncludeEdgeRefs() {
        return this.isIncludeAllEdgeRefs() || this.isIncludeInEdgeRefs() || this.isIncludeOutEdgeRefs() || this.getEdgeLabelsOfEdgeRefsToInclude() != null && this.getEdgeLabelsOfEdgeRefsToInclude().size() > 0;
    }

    public boolean hasEdgeLabelsOfEdgeRefsToInclude() {
        return this.getEdgeLabelsOfEdgeRefsToInclude() != null && this.getEdgeLabelsOfEdgeRefsToInclude().size() > 0;
    }

    public void validateHasEdgeFetchHints(Direction direction, String ... labels) {
        if (!this.isIncludeEdgeRefs()) {
            throw new GeMissingFetchHintException(this, "edgeRefs");
        }
        switch (direction) {
            case OUT: {
                if (this.isIncludeOutEdgeRefs() || this.hasEdgeLabelsOfEdgeRefsToInclude()) break;
                throw new GeMissingFetchHintException(this, "outEdgeRefs or edgeLabels");
            }
            case IN: {
                if (this.isIncludeInEdgeRefs() || this.hasEdgeLabelsOfEdgeRefsToInclude()) break;
                throw new GeMissingFetchHintException(this, "inEdgeRefs or edgeLabels");
            }
        }
        if (!(labels == null || labels.length == 0 || this.isIncludeAllEdgeRefs() || this.isIncludeInEdgeRefs() || this.isIncludeOutEdgeRefs() || this.getEdgeLabelsOfEdgeRefsToInclude() == null || this.getEdgeLabelsOfEdgeRefsToInclude().size() <= 0)) {
            for (String label : labels) {
                if (this.getEdgeLabelsOfEdgeRefsToInclude().contains((Object)label)) continue;
                throw new GeMissingFetchHintException(this, "edgeLabel:" + label);
            }
        }
    }

    public String toString() {
        return "FetchHints{includeAllProperties=" + this.includeAllProperties + ", propertyNamesToInclude=" + this.setToString(this.propertyNamesToInclude) + ", includeAllPropertyMetadata=" + this.includeAllPropertyMetadata + ", metadataKeysToInclude=" + this.setToString(this.metadataKeysToInclude) + ", includeHidden=" + this.includeHidden + ", includeAllEdgeRefs=" + this.includeAllEdgeRefs + ", edgeLabelsOfEdgeRefsToInclude=" + this.setToString(this.edgeLabelsOfEdgeRefsToInclude) + ", includeEdgeLabelsAndCounts=" + this.includeEdgeLabelsAndCounts + ", includeExtendedDataTableNames=" + this.includeExtendedDataTableNames + '}';
    }

    private String setToString(ImmutableSet<String> set) {
        return set == null ? "" : Joiner.on((String)",").join(set);
    }

    public static FetchHintsBuilder builder() {
        return new FetchHintsBuilder();
    }

    public static FetchHintsBuilder builder(FetchHints fetchHints) {
        return new FetchHintsBuilder(fetchHints);
    }

    public void assertPropertyIncluded(String name) {
        if (this.isIncludeProperty(name)) {
            return;
        }
        throw new GeMissingFetchHintException(this, "property:" + name);
    }

    public void assertMetadataIncluded(String key) {
        if (this.isIncludeMetadata(key)) {
            return;
        }
        throw new GeMissingFetchHintException(this, "metadata:" + key);
    }

    public boolean hasFetchHints(FetchHints fetchHints) {
        if (fetchHints.includeHidden && !this.includeHidden) {
            return false;
        }
        if (fetchHints.includeEdgeLabelsAndCounts && !this.includeEdgeLabelsAndCounts) {
            return false;
        }
        if (fetchHints.includeAllEdgeRefs && !this.includeAllEdgeRefs) {
            return false;
        }
        if (fetchHints.includeOutEdgeRefs && !this.includeOutEdgeRefs && !this.includeAllEdgeRefs) {
            return false;
        }
        if (fetchHints.includeInEdgeRefs && !this.includeInEdgeRefs && !this.includeAllEdgeRefs) {
            return false;
        }
        if (fetchHints.includeEdgeIds && !this.includeEdgeIds) {
            return false;
        }
        if (fetchHints.includeEdgeVertexIds && !this.includeEdgeVertexIds) {
            return false;
        }
        if (fetchHints.includeExtendedDataTableNames && !this.includeExtendedDataTableNames) {
            return false;
        }
        if (fetchHints.includeAllPropertyMetadata && !this.includeAllPropertyMetadata) {
            return false;
        }
        if (fetchHints.includeAllProperties && !this.includeAllProperties) {
            return false;
        }
        if (fetchHints.edgeLabelsOfEdgeRefsToInclude != null && fetchHints.edgeLabelsOfEdgeRefsToInclude.size() > 0 && !this.isEdgeLabelsOfEdgeRefsIncluded(fetchHints.edgeLabelsOfEdgeRefsToInclude)) {
            return false;
        }
        if (fetchHints.propertyNamesToInclude != null && fetchHints.propertyNamesToInclude.size() > 0 && !this.isPropertyNamesIncluded(fetchHints.propertyNamesToInclude)) {
            return false;
        }
        return fetchHints.metadataKeysToInclude == null || fetchHints.metadataKeysToInclude.size() <= 0 || this.isMetadataKeysIncluded(fetchHints.metadataKeysToInclude);
    }

    private boolean isMetadataKeysIncluded(ImmutableSet<String> metadataKeysToInclude) {
        if (this.includeAllPropertyMetadata) {
            return true;
        }
        if (this.metadataKeysToInclude == null) {
            return false;
        }
        for (String metadataKey : metadataKeysToInclude) {
            if (this.metadataKeysToInclude.contains((Object)metadataKey)) continue;
            return false;
        }
        return true;
    }

    private boolean isPropertyNamesIncluded(ImmutableSet<String> propertyNamesToInclude) {
        if (this.includeAllProperties) {
            return true;
        }
        if (this.propertyNamesToInclude == null) {
            return false;
        }
        for (String propertyName : propertyNamesToInclude) {
            if (this.propertyNamesToInclude.contains((Object)propertyName)) continue;
            return false;
        }
        return true;
    }

    private boolean isEdgeLabelsOfEdgeRefsIncluded(ImmutableSet<String> edgeLabelsOfEdgeRefsToInclude) {
        if (this.includeAllEdgeRefs) {
            return true;
        }
        if (this.edgeLabelsOfEdgeRefsToInclude == null) {
            return false;
        }
        for (String edgeLabel : edgeLabelsOfEdgeRefsToInclude) {
            if (this.edgeLabelsOfEdgeRefsToInclude.contains((Object)edgeLabel)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchHints that = (FetchHints)o;
        return this.includeAllProperties == that.includeAllProperties && this.includeAllPropertyMetadata == that.includeAllPropertyMetadata && this.includeHidden == that.includeHidden && this.includeAllEdgeRefs == that.includeAllEdgeRefs && this.includeOutEdgeRefs == that.includeOutEdgeRefs && this.includeInEdgeRefs == that.includeInEdgeRefs && this.includeEdgeIds == that.includeEdgeIds && this.includeEdgeVertexIds == that.includeEdgeVertexIds && this.includeEdgeLabelsAndCounts == that.includeEdgeLabelsAndCounts && this.includeExtendedDataTableNames == that.includeExtendedDataTableNames && Objects.equals(this.propertyNamesToInclude, that.propertyNamesToInclude) && Objects.equals(this.metadataKeysToInclude, that.metadataKeysToInclude) && Objects.equals(this.edgeLabelsOfEdgeRefsToInclude, that.edgeLabelsOfEdgeRefsToInclude);
    }

    public int hashCode() {
        return Objects.hash(this.includeAllProperties, this.propertyNamesToInclude, this.includeAllPropertyMetadata, this.metadataKeysToInclude, this.includeHidden, this.includeAllEdgeRefs, this.includeOutEdgeRefs, this.includeInEdgeRefs, this.includeEdgeIds, this.includeEdgeVertexIds, this.edgeLabelsOfEdgeRefsToInclude, this.includeEdgeLabelsAndCounts, this.includeExtendedDataTableNames);
    }

    public static FetchHints union(FetchHints ... fetchHints) {
        return FetchHints.union(Arrays.asList(fetchHints));
    }

    public static FetchHints union(Iterable<FetchHints> fetchHints) {
        boolean includeAllProperties = false;
        HashSet<String> propertyNamesToInclude = null;
        boolean includeAllPropertyMetadata = false;
        HashSet<String> metadataKeysToInclude = null;
        Boolean includeHidden = null;
        boolean includeAllEdgeRefs = false;
        boolean includeOutEdgeRefs = false;
        boolean includeInEdgeRefs = false;
        boolean includeEdgeIds = false;
        boolean includeEdgeVertexIds = false;
        boolean includeEdgeLabelsAndCounts = false;
        boolean includeExtendedDataTableNames = false;
        HashSet<String> edgeLabelsOfEdgeRefsToInclude = null;
        for (FetchHints fetchHint : fetchHints) {
            if (fetchHint.isIncludeAllProperties()) {
                includeAllProperties = true;
            }
            if (fetchHint.isIncludeAllPropertyMetadata()) {
                includeAllPropertyMetadata = true;
            }
            if (fetchHint.isIncludeAllEdgeRefs()) {
                includeAllEdgeRefs = true;
            }
            if (fetchHint.isIncludeOutEdgeRefs()) {
                includeOutEdgeRefs = true;
            }
            if (fetchHint.isIncludeInEdgeRefs()) {
                includeInEdgeRefs = true;
            }
            if (fetchHint.isIncludeEdgeIds()) {
                includeEdgeIds = true;
            }
            if (fetchHint.isIncludeEdgeVertexIds()) {
                includeEdgeVertexIds = true;
            }
            if (fetchHint.isIncludeEdgeLabelsAndCounts()) {
                includeEdgeLabelsAndCounts = true;
            }
            if (fetchHint.isIncludeExtendedDataTableNames()) {
                includeExtendedDataTableNames = true;
            }
            if (includeHidden != null && includeHidden.booleanValue() != fetchHint.isIncludeHidden()) {
                throw new GeException("Incompatible fetch hints to combine (includeHidden).");
            }
            includeHidden = fetchHint.isIncludeHidden();
            if (fetchHint.getPropertyNamesToInclude() != null) {
                if (propertyNamesToInclude == null) {
                    propertyNamesToInclude = new HashSet<String>((Collection<String>)fetchHint.getPropertyNamesToInclude());
                } else {
                    propertyNamesToInclude.addAll((Collection<String>)fetchHint.getPropertyNamesToInclude());
                }
            }
            if (fetchHint.getMetadataKeysToInclude() != null) {
                if (metadataKeysToInclude == null) {
                    metadataKeysToInclude = new HashSet<String>((Collection<String>)fetchHint.getMetadataKeysToInclude());
                } else {
                    metadataKeysToInclude.addAll((Collection<String>)fetchHint.getMetadataKeysToInclude());
                }
            }
            if (fetchHint.getEdgeLabelsOfEdgeRefsToInclude() == null) continue;
            if (edgeLabelsOfEdgeRefsToInclude == null) {
                edgeLabelsOfEdgeRefsToInclude = new HashSet<String>((Collection<String>)fetchHint.getEdgeLabelsOfEdgeRefsToInclude());
                continue;
            }
            edgeLabelsOfEdgeRefsToInclude.addAll((Collection<String>)fetchHint.getEdgeLabelsOfEdgeRefsToInclude());
        }
        return new FetchHints(includeAllProperties, (ImmutableSet<String>)(propertyNamesToInclude == null ? null : ImmutableSet.copyOf(propertyNamesToInclude)), includeAllPropertyMetadata, (ImmutableSet<String>)(metadataKeysToInclude == null ? null : ImmutableSet.copyOf(metadataKeysToInclude)), includeHidden == null ? false : includeHidden, includeAllEdgeRefs, includeOutEdgeRefs, includeInEdgeRefs, includeEdgeIds, includeEdgeVertexIds, (ImmutableSet<String>)(edgeLabelsOfEdgeRefsToInclude == null ? null : ImmutableSet.copyOf(edgeLabelsOfEdgeRefsToInclude)), includeEdgeLabelsAndCounts, includeExtendedDataTableNames);
    }
}

