/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class FetchHintsBuilder {
    private boolean includeAllProperties;
    private Set<String> propertyNamesToInclude;
    private boolean includeAllPropertyMetadata;
    private Set<String> metadataKeysToInclude;
    private boolean includeHidden;
    private boolean includeAllEdgeRefs;
    private boolean includeOutEdgeRefs;
    private boolean includeInEdgeRefs;
    private boolean includeEdgeIds = true;
    private boolean includeEdgeVertexIds = true;
    private Set<String> edgeLabelsOfEdgeRefsToInclude;
    private boolean includeEdgeLabelsAndCounts;
    private boolean includeExtendedDataTableNames;

    public FetchHintsBuilder() {
    }

    public FetchHintsBuilder(FetchHints fetchHints) {
        this.includeAllProperties = fetchHints.isIncludeAllProperties();
        this.propertyNamesToInclude = fetchHints.getPropertyNamesToInclude();
        this.includeAllPropertyMetadata = fetchHints.isIncludeAllPropertyMetadata();
        this.metadataKeysToInclude = fetchHints.getMetadataKeysToInclude();
        this.includeHidden = fetchHints.isIncludeHidden();
        this.includeAllEdgeRefs = fetchHints.isIncludeAllEdgeRefs();
        this.includeOutEdgeRefs = fetchHints.isIncludeOutEdgeRefs();
        this.includeInEdgeRefs = fetchHints.isIncludeInEdgeRefs();
        this.includeEdgeIds = fetchHints.isIncludeEdgeIds();
        this.includeEdgeVertexIds = fetchHints.isIncludeEdgeVertexIds();
        this.edgeLabelsOfEdgeRefsToInclude = fetchHints.getEdgeLabelsOfEdgeRefsToInclude();
        this.includeEdgeLabelsAndCounts = fetchHints.isIncludeEdgeLabelsAndCounts();
        this.includeExtendedDataTableNames = fetchHints.isIncludeExtendedDataTableNames();
    }

    public FetchHints build() {
        if (!this.isIncludeProperties() && this.isIncludePropertyMetadata()) {
            this.includeAllProperties = true;
        }
        if ((this.includeAllEdgeRefs || this.includeOutEdgeRefs || this.includeInEdgeRefs) && !this.includeEdgeIds && !this.includeEdgeVertexIds) {
            throw new GeException("Cannot exclude both includeEdgeIds and includeEdgeVertexIds. Instead exclude edge refs.");
        }
        return new FetchHints(this.includeAllProperties, (ImmutableSet<String>)(this.propertyNamesToInclude == null ? null : ImmutableSet.copyOf(this.propertyNamesToInclude)), this.includeAllPropertyMetadata, (ImmutableSet<String>)(this.metadataKeysToInclude == null ? null : ImmutableSet.copyOf(this.metadataKeysToInclude)), this.includeHidden, this.includeAllEdgeRefs, this.includeOutEdgeRefs || this.includeAllEdgeRefs, this.includeInEdgeRefs || this.includeAllEdgeRefs, this.includeEdgeIds, this.includeEdgeVertexIds, (ImmutableSet<String>)(this.edgeLabelsOfEdgeRefsToInclude == null ? null : ImmutableSet.copyOf(this.edgeLabelsOfEdgeRefsToInclude)), this.includeEdgeLabelsAndCounts, this.includeExtendedDataTableNames);
    }

    public FetchHintsBuilder setIncludeEdgeIds(boolean includeEdgeIds) {
        this.includeEdgeIds = includeEdgeIds;
        return this;
    }

    public FetchHintsBuilder setIncludeEdgeVertexIds(boolean includeEdgeVertexIds) {
        this.includeEdgeVertexIds = includeEdgeVertexIds;
        return this;
    }

    public static FetchHintsBuilder parse(JSONObject fetchHintsJson) {
        if (fetchHintsJson == null) {
            fetchHintsJson = new JSONObject();
        }
        return new FetchHintsBuilder().setIncludeAllProperties(fetchHintsJson.optBoolean("includeAllProperties", false)).setIncludeAllPropertyMetadata(fetchHintsJson.optBoolean("includeAllPropertyMetadata", false)).setIncludeHidden(fetchHintsJson.optBoolean("includeHidden", false)).setIncludeAllEdgeRefs(fetchHintsJson.optBoolean("includeAllEdgeRefs", false)).setIncludeOutEdgeRefs(fetchHintsJson.optBoolean("includeOutEdgeRefs", false)).setIncludeInEdgeRefs(fetchHintsJson.optBoolean("includeInEdgeRefs", false)).setIncludeEdgeLabelsAndCounts(fetchHintsJson.optBoolean("includeEdgeLabelsAndCounts", false)).setIncludeExtendedDataTableNames(fetchHintsJson.optBoolean("includeExtendedDataTableNames", false)).setPropertyNamesToInclude(fetchHintsJson.has("propertyNamesToInclude") ? FetchHintsBuilder.jsonArrayToSet(fetchHintsJson.getJSONArray("propertyNamesToInclude")) : null).setMetadataKeysToInclude(fetchHintsJson.has("metadataKeysToInclude") ? FetchHintsBuilder.jsonArrayToSet(fetchHintsJson.getJSONArray("metadataKeysToInclude")) : null).setEdgeLabelsOfEdgeRefsToInclude(fetchHintsJson.has("edgeLabelsOfEdgeRefsToInclude") ? FetchHintsBuilder.jsonArrayToSet(fetchHintsJson.getJSONArray("edgeLabelsOfEdgeRefsToInclude")) : null);
    }

    private static Set<String> jsonArrayToSet(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            set.add((String)jsonArray.get(i));
        }
        return set;
    }

    private boolean isIncludeProperties() {
        return this.includeAllProperties || this.propertyNamesToInclude != null && this.propertyNamesToInclude.size() > 0;
    }

    private boolean isIncludePropertyMetadata() {
        return this.includeAllPropertyMetadata || this.metadataKeysToInclude != null && this.metadataKeysToInclude.size() > 0;
    }

    public FetchHintsBuilder setIncludeAllProperties(boolean includeAllProperties) {
        this.includeAllProperties = includeAllProperties;
        return this;
    }

    public FetchHintsBuilder setPropertyNamesToInclude(Set<String> propertyNamesToInclude) {
        this.propertyNamesToInclude = propertyNamesToInclude;
        return this;
    }

    public FetchHintsBuilder setPropertyNamesToInclude(String ... propertyNamesToInclude) {
        this.propertyNamesToInclude = Sets.newHashSet((Object[])propertyNamesToInclude);
        return this;
    }

    public FetchHintsBuilder setIncludeAllPropertyMetadata(boolean includeAllPropertyMetadata) {
        this.includeAllPropertyMetadata = includeAllPropertyMetadata;
        return this;
    }

    public FetchHintsBuilder setMetadataKeysToInclude(Set<String> metadataKeysToInclude) {
        this.metadataKeysToInclude = metadataKeysToInclude;
        return this;
    }

    public FetchHintsBuilder setMetadataKeysToInclude(String ... metadataKeysToInclude) {
        this.metadataKeysToInclude = Sets.newHashSet((Object[])metadataKeysToInclude);
        return this;
    }

    public FetchHintsBuilder setIncludeHidden(boolean includeHidden) {
        this.includeHidden = includeHidden;
        return this;
    }

    public FetchHintsBuilder setIncludeAllEdgeRefs(boolean includeAllEdgeRefs) {
        this.includeAllEdgeRefs = includeAllEdgeRefs;
        return this;
    }

    public FetchHintsBuilder setIncludeOutEdgeRefs(boolean includeOutEdgeRefs) {
        this.includeOutEdgeRefs = includeOutEdgeRefs;
        return this;
    }

    public FetchHintsBuilder setIncludeInEdgeRefs(boolean includeInEdgeRefs) {
        this.includeInEdgeRefs = includeInEdgeRefs;
        return this;
    }

    public FetchHintsBuilder setEdgeLabelsOfEdgeRefsToInclude(Set<String> edgeLabelsOfEdgeRefsToInclude) {
        this.edgeLabelsOfEdgeRefsToInclude = edgeLabelsOfEdgeRefsToInclude;
        return this;
    }

    public FetchHintsBuilder setEdgeLabelsOfEdgeRefsToInclude(String ... edgeLabelsOfEdgeRefsToInclude) {
        this.edgeLabelsOfEdgeRefsToInclude = Sets.newHashSet((Object[])edgeLabelsOfEdgeRefsToInclude);
        return this;
    }

    public FetchHintsBuilder setIncludeEdgeLabelsAndCounts(boolean includeEdgeLabelsAndCounts) {
        this.includeEdgeLabelsAndCounts = includeEdgeLabelsAndCounts;
        return this;
    }

    public FetchHintsBuilder setIncludeExtendedDataTableNames(boolean includeExtendedDataTableNames) {
        this.includeExtendedDataTableNames = includeExtendedDataTableNames;
        return this;
    }
}

